package cn.quantgroup.cashloanflowboss.api.login.controller;

import cn.quantgroup.cashloanflowboss.api.login.model.LoginFormModel;
import cn.quantgroup.cashloanflowboss.api.login.service.LoginService;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * Created by WeiWei on 2019/7/22.
 */
@RestController
public class LogController {

    @Autowired
    private LoginService loginService;

    /**
     * 登入
     *
     * @param loginFormModel
     * @return
     */
    @PostMapping("/login")
    public Result<String> login(@RequestBody @Valid LoginFormModel loginFormModel) {
        return new Result<>(ApplicationStatus.SUCCESS, this.loginService.login(loginFormModel.getUsername(), loginFormModel.getPassword()));
    }

    /**
     * 登出
     *
     * @return
     */
    @DeleteMapping("/logout")
    @Security(authorityId = "Log.logout", authorities = Authority.READ)
    public Result<Boolean> logout() {
        return new Result<>(ApplicationStatus.SUCCESS, this.loginService.logout());
    }

}
