package cn.quantgroup.cashloanflowboss.api.order.model;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@Data
public class OrderVo {
    private Long id;
    private Long channelId;
    private String channelOrderNumber;
    private Long loanId;
    private String applyNo;
    private Date createdAt;
    private String status;
    /**
     * [ {action:"audit",name:"审核"},{},{}...  ]
     */
    private List<OptButton> opt;
    private String message;


    @Data
    public static class OptButton {
        private String action;
        private String name;
    }

    public enum  OptButtonAction {
        audit("审批"),
        cancel("贷前关单"),
        second_audit("二次风控审批"),
        pay_succ("放款成功"),
        pay_fail("放款失败"),
        withdraw_second("存管提现"),
        cancel_after("贷后关单");

        OptButtonAction(String desc) {
            this.desc = desc;
        }

        private String desc;

        public String getDesc(){
            return this.desc;
        }
    }




}
