package cn.quantgroup.cashloanflowboss.spi.model;

import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * Created by suntao on 18/01/15.
 */
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class JsonResult<T> implements Serializable {

    String ZERO_FILL_TEMPLATE = "%04d";
    String SUCCESS_BUSINESS_CODE = "0000";
    String SUCCESS_STRING_CODE = "0000";

    public static final Long SUCCESS_CODE = 0L;

    private String msg = "";

    private String code = "0000";

    // 业务错误码
    private String businessCode = "0000";

    private T data = null;


    public JsonResult(String msg, Long code, T data) {
        this.msg = msg;
        this.code = String.format(ZERO_FILL_TEMPLATE, code);
        this.data = data;
    }

    public JsonResult(String msg, Long code, T data, Long businessCode) {
        this.msg = msg;
        this.code = String.format(ZERO_FILL_TEMPLATE, code);
        this.data = data;
        this.businessCode = String.format(ZERO_FILL_TEMPLATE, businessCode);
    }

    /**
     * 构造成功的JsonResult
     * @param msg  String
     * @param data Object
     * @return JsonResult
     */
    @SuppressWarnings("unchecked")
    public static<T> JsonResult buildSuccess(String msg, T data) {
        return new JsonResult(msg, SUCCESS_CODE, data, 0L);
    }

    /**
     * 构造状态不正确的JsonResult
     * @param msg  String
     * @return JsonResult
     */
    @SuppressWarnings("unchecked")
    public static JsonResult buildError(String msg) {
        return new JsonResult(msg, SUCCESS_CODE, null, 1L);
    }

    /**
     * 构造状态不正确的JsonResult
     * @param msg  String
     * @return JsonResult
     */
    @SuppressWarnings("unchecked")
    public static<T> JsonResult buildError(String msg, T data) {
        return new JsonResult(msg, SUCCESS_CODE, data, 1L);
    }

    @SuppressWarnings("unchecked")
    public static JsonResult buildError(String msg, Long busniessId) {
        return new JsonResult(msg, SUCCESS_CODE, null, busniessId);
    }

    @SuppressWarnings("unchecked")
    public static<T> JsonResult buildError(String msg, Long busniessId, T data) {
        return new JsonResult(msg, SUCCESS_CODE, data, busniessId);
    }

    /**
     * 是否成功状态
     * @return
     */
    public boolean isSuccess(){
         return SUCCESS_STRING_CODE.equals(this.getCode()) && SUCCESS_BUSINESS_CODE.equals(this.getBusinessCode());
    }

    public String getMessage() {
        return this.msg;
    }

    @Override
    public String toString() {
        return JSONTools.serialize(this);
    }
}
