package cn.quantgroup.cashloanflowboss;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.transaction.annotation.EnableTransactionManagement;
@EnableRedisHttpSession
@EnableTransactionManagement
@SpringBootApplication(scanBasePackages = {"cn.quantgroup.cashloanflowboss"})
@Configuration
@EnableAutoConfiguration
@EnableFeignClients
@EnableAsync(proxyTargetClass = true)
@EnableScheduling
public class Bootstrap {

	public static void main(String[] args) {
		SpringApplication.run(Bootstrap.class, args);
	}

}
