package cn.quantgroup.cashloanflowboss.api.login.auth.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * api 授权用户信息
 *
 * @author Jie.Feng
 * @date 2017/12/22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LoginUser implements Serializable {
    private static final long serialVersionUID = -2770987776683983348L;


    private String name;
    private String phone;
    private String user;
    private String token;
    /**
     * 一个用户在某个系统中可能有多个权限
     * 系统名称_角色
     */
    private List<String> roles = new ArrayList<>();


    public LoginUser(String name, String phone, String user, String token) {
        this.name = name;
        this.phone = phone;
        this.user = user;
        this.token = token;
    }


    public void addRole(String systemName, String role) {
        String permission = systemName + "_" + role;
        if (!this.roles.contains(permission)) {
            this.roles.add(permission);
        }
    }

}
