package cn.quantgroup.cashloanflowboss.api.user.model;

import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserRank;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.component.validator.constraints.NotEmpty;
import cn.quantgroup.cashloanflowboss.core.persistence.Primary;
import lombok.Data;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 保存用户 编辑用户model
 * Created by suntao on 2019/7/22.
 */
@Data
public class UserInfoModel {

    private Long id;

    /**
     * 用户名
     */
    @NotEmpty(message = "用户名不能为空")
    private String username;

    /**
     * 昵称
     */
    @NotEmpty(message = "用户昵称不能为空")
    private String nickname;

    /**
     * 密码
     */
    private String password;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 用户级别
     */
    @NotNull(message = "用户级别不能为空")
    private UserRank rank;

    /**
     * 用户角色列表
     */
    private Role roles;

    /**
     * 用户状态
     */
    @NotNull(message = "用户活跃状态不能为空")
    private UserStatus status;

}
