package cn.quantgroup.cashloanflowboss.spi.clf.service;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "CLFServiceCenter", url = "${qapi.http}", fallback = CLFCenter.Fallback.class)
public interface CLFCenter {

    @PostMapping(value = "/test//loanMq/batch", consumes = "application/x-www-form-urlencoded")
    void loanMq(@RequestParam("json") String loanMq);

    @GetMapping(value = "/configuration/lPm6usTlPYLqtDPQHIldvszWakDHlDh4", consumes = "application/x-www-form-urlencoded")
    void reloadKASetting(@RequestParam("token") String token);

    @Component
    class Fallback implements CLFCenter {

        @Override
        public void loanMq(String loanMq) {
            return;
        }

        @Override
        public void reloadKASetting(String token) {

        }
    }


}
