package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by WeiWei on 2019/8/13.
 */
@XYQBDataSource
@Repository
public interface ContractRepository extends JpaRepository<Contract, Long> {

    /**
     * 更新合同状态
     *
     * @param userId
     * @param status
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update contract set generate_status = ?2 where user_id = ?1", nativeQuery = true)
    int updateContractStatus(Long userId, Integer status);


    /**
     * 更新合同状态
     *
     * @param userId
     * @Param loanApplicationHistoryId
     * @param status
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update contract set generate_status = ?2 where user_id = ?1 and loan_application_history_id=?3 ", nativeQuery = true)
    int updateContractStatusByUserIdAndLoanApplicationHistoryId (Long userId, Integer status,Long loanApplicationHistoryId);



    @Query(value = "select * from contract where user_id = ?1 order by id desc limit 1", nativeQuery = true)
    Contract findByUserIdLastOne(Long qgUserId);
}
