package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ScheduleService;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * Created by shang on 2019/12/20.
 */
@Slf4j
@Service
public class ScheduleServiceImpl implements ScheduleService {

    @Autowired
    JolyneService jolyneService;
    /**
     *应用风险处理工作
     * */
    @Override
    public void applyRiskHandleJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.ApplyRiskHandleJob");
        jolyneService.reloadJob("cn.qg.clotho.job.ApplyRiskHandleJob");
    }

    /**
     *分配资金方
     * */
    @Override
    public void applyCashDataJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.ApplyCashDataJob");
        jolyneService.reloadJob("cn.qg.clotho.job.ApplyCashDataJob");
    }

    /**
     *拉取放款时间段资金方
     * */
    @Override
    public void loanDataJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.LoanDataJob");
        jolyneService.reloadJob("cn.qg.clotho.job.LoanDataJob");
    }


    @Override
    public void fundingSelectJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.FundingSelectJob");
        jolyneService.reloadJob("cn.qg.clotho.job.FundingSelectJob");
    }

    @Override
    public void fetchDataLoanJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.FetchDataLoanJob");
//        jolyneService.reloadJob("cn.qg.clotho.job.FetchDataLoanJob");
    }

    @Override
    public void autoLoanFetchJob() throws Exception {
//        GetScheduleJob.getScheduleJob(nameSpace, "clotho-elastic-job", "cn.qg.clotho.job.dataflow.AutoLoanFetchJob");
        jolyneService.reloadJob("cn.qg.clotho.job.AutoLoanFetchJob");
    }
}
