package cn.quantgroup.cashloanflowboss.api.oneclickdata.repository;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by shang on 2019/12/11.
 */
@CashLoanFlowBossDataSource
@Repository
public interface OneClickDataRespository extends JpaRepository<OneClickData, Long>, PagingAndSortingRepository<OneClickData, Long>, JpaSpecificationExecutor<OneClickData> {
//     通过userid、渠道订单号、授信状态、放款状态查询、渠道类型
    @Query(value = "select * from one_click_data where user_id= ?1 and  credit_status = ?2 and loan_status= ?3 and channel_code= ?4 order by id desc limit 1", nativeQuery = true)
    OneClickData findByUserIdAndCreditStatusAndLoanStatusAndChannelCode(String userId,Integer creditStatus,Integer loanStatus,String channelCode);


    //     通过userid、订单号查看
    @Query(value = "select * from one_click_data where user_id= ?1 and  order_no = ?2 order by id desc limit 1", nativeQuery = true)
    OneClickData findByUserIdAndOrderNo(String userId,String OrderNo);


    //     通过订单号查看
    @Query(value = "select * from one_click_data where order_no = ?1 order by id desc limit 1", nativeQuery = true)
    OneClickData findByOrderNo(String OrderNo);

    //     通过放款号查看
    @Query(value = "select * from one_click_data where loan_id = ?1 order by id desc limit 1", nativeQuery = true)
    OneClickData findByLoanId(String loanId);

    //     通过授信状态查询,申请类型是非1的
    @Query(value = "select * from one_click_data where credit_status = ?1 and  type not in ?2  order by id desc limit 1", nativeQuery = true)
    List<OneClickData> findByCreditStatusNotInType(Integer creditStatus,Integer type);

    //    通过id修改 放款loanid
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set loan_id= ?1 where id= ?2", nativeQuery = true)
    int updateById(String loanId ,Long id);

    //    通过id修改 授信状态
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set credit_status= ?1 where id= ?2", nativeQuery = true)
    int updateCreditStatusById(Integer creditStatus ,Long id);


    //    通过id修改 放款状态
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set loan_status= ?1 where id= ?2", nativeQuery = true)
    int updateLoanStatusById(Integer loanStatus ,Long id);



    //    通过id修改 放款loanid 放款状态loan_status
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set loan_id= ?1,loan_status= ?2 where id= ?3", nativeQuery = true)
    int updateCreditStatusAndLoanStatusById(String loanId,Integer loanStatus ,Long id);



    //    通过id修改 添加订单号 产品id token信息
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set quota_record_order_no= ?1,order_no= ?2,product_id= ?3,token= ?4,biz_type= ?5 where id= ?6", nativeQuery = true)
    int updateById(String quotaRecordOrderNo,String orderNo,String productId,String token,Integer bizType ,Long id);
}
