package cn.quantgroup.cashloanflowboss.api.oneclickdata.controller;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CommMethod;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.OneClickDataOperateService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.OneClickDataQueueOperateService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.utils.RandomlyGeneratedParameters;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.logging.Logger;

/**
 * Created by shang on 2019/12/3.
 */
@Slf4j
@RestController
@RequestMapping("/oneclickdate")
public class OneClickDataController {

    @Autowired
    private OneClickDataOperateService oneClickDataOperateService;
    @Autowired
    private OneClickDataQueueOperateService oneClickDataQueueOperateService;
    @Autowired
    CommMethod commMethod;
    private OneClickModel oneClickModelNew;

    @PostMapping("/v1/type")
    public Result OneClickDataOperate(@RequestBody @Valid OneClickModel oneClickModel) throws Exception {
        log.info("实体类oneClickModel={}",oneClickModel);
        if (oneClickModel.getType().isEmpty()) {
            log.info("打印一下oneClickModel.getType()={}",oneClickModel.getType());
            return Result.buildFail("操作类型必填");
        } else {
             oneClickModelNew=setDefaultValue(oneClickModel);
            log.info("打印最新的oneClickModelNew={}", oneClickModelNew);
            if (oneClickModel.getType().equals(String.valueOf(TypeEnum.APPLY.getCode()))) {
                return OnekeyApply(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.CASHWITHDRAWAL.getCode()))) {
                return OneKeyCashWithdrawal(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.CREDITSUCCESS.getCode())) || oneClickModel.getType().equals(String.valueOf(TypeEnum.CREDITFAIL.getCode()))) {
                return OneKeyCreditSuccessOrFail(oneClickModelNew);
            } else if (oneClickModel.getType().equals(String.valueOf(TypeEnum.LOANSUCCESS.getCode())) || oneClickModel.getType().equals(String.valueOf(TypeEnum.LOANFAIL.getCode()))) {
                return OneKeyLoanSuccessOrFail(oneClickModelNew);
            } else {
                return Result.buildFail("没有匹配到操作类型Type");
            }
        }


    }

    @PostMapping("/v1/select")
    public Result OneClickDataSelect(@RequestBody @Valid OneClickSelectModel oneClickSelectModel ){
        log.info("打印一下oneClickSelectModel={}",oneClickSelectModel);
       return Result.buildSuccess(oneClickDataOperateService.findOneClickSelectModelByCriteriaQueryPage(oneClickSelectModel));
    }

    @GetMapping("/v1/cashwith")
    public Result OneClickDataMq(@RequestParam (value = "queueMsg") String queueMsg){
        log.info("打印一下queueMsg={}",queueMsg);
        oneClickDataQueueOperateService.getCreditNotifyIsSucess(queueMsg);
        return Result.buildSuccess("ok");
    }



    @GetMapping("/v1/channelCode")
    public Result OneClickDataChannelCodeList(){
        List<OneClickChannelCodeModel> oneClickChannelCodeModelList= commMethod.getChannelCodeList();
        return Result.buildSuccess(commMethod);
    }


    public Result OnekeyApply(OneClickModel oneClickModel) {

        return  oneClickDataOperateService.OnekeyApply(oneClickModel);
    }

    public Result OneKeyCashWithdrawal(OneClickModel oneClickModel) throws Exception{


        return  oneClickDataOperateService.OneKeyCashWithdrawal(oneClickModel);
    }

    public Result OneKeyCreditSuccessOrFail(OneClickModel oneClickModel) throws Exception {

        return oneClickDataOperateService.OneKeyCreditSuccessOrFail(oneClickModel);
    }

    public Result OneKeyLoanSuccessOrFail(OneClickModel oneClickModel) throws Exception {
        return  oneClickDataOperateService.OneKeyLoanSuccessOrFail(oneClickModel);
    }

    public OneClickModel setDefaultValue(OneClickModel oneClickModel){


        if (StringUtils.isBlank(oneClickModel.getPhone())){
          String randPhone;
          randPhone = RandomlyGeneratedParameters.getTel();
          oneClickModel.setPhone(randPhone.toString());
        }

        if(StringUtils.isBlank(oneClickModel.getChannel())){
          oneClickModel.setChannel("1");
        }

        if(StringUtils.isBlank(oneClickModel.getAmount()) ){
          oneClickModel.setAmount("10000");
        }

        if(StringUtils.isBlank(oneClickModel.getFundID())){
          oneClickModel.setFundID("710");
        }

        if(StringUtils.isBlank(oneClickModel.getProductId())){
          oneClickModel.setProductId("1");
        }

        if(StringUtils.isBlank(oneClickModel.getTermNo())){
          oneClickModel.setTermNo("12");
        }
        log.info("打印重新设置的oneClickModel={}",oneClickModel);
        return oneClickModel;
    }


    public static void main(String[] arg) throws Exception {
        OneClickDataController oneclick=new OneClickDataController();
        OneClickModel oneClickModel2 = new OneClickModel();
        oneClickModel2.setType("1");
        oneClickModel2.setChannel("159858");
        oneclick.OneClickDataOperate(oneClickModel2);
    }
}


