package cn.quantgroup.cashloanflowboss.core.configuration;

import cn.quantgroup.cashloanflowboss.api.role.entity.Permission;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.component.security.SecurityHandler;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * Created by WeiWei on 2019/7/26.
 */
@Configuration
public class ApplicationSecurityConfiguration implements SecurityHandler {

    @Autowired
    private HttpServletRequest request;

    @Override
    public boolean doAuthentication(MethodInvocation invocation, String authorityId, Authority[] authority) throws Throwable {

        // 获取Session
        HttpSession session = this.request.getSession(false);

        // 检查是否已登录
        Assert.isTrue((Objects.isNull(session) || Objects.isNull(session.getAttribute(ApplicationDictionary.SECURITY_KEY))), ApplicationStatus.AUTHENTICATION_FAILURE);

        // 读取Session授权内容
        List<Permission> permissions = JSONTools.deserialize(String.valueOf(session.getAttribute(ApplicationDictionary.SECURITY_KEY)), new TypeReference<List<Permission>>() {});

        if (Objects.nonNull(permissions)) {

            Permission permission = permissions.parallelStream().filter(p2 -> p2.getId().equals(authorityId)).findFirst().orElseThrow(ApplicationStatus.INVALID_AUTHORITY::throwException);

            return !(Objects.isNull(permission.getAuthorities()) || permission.getAuthorities().isEmpty()) && permission.getAuthorities().parallelStream().anyMatch(a -> Arrays.asList(authority).contains(a));

        }

        return false;

    }

}
