package cn.quantgroup.cashloanflowboss.core;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Objects;

/**
 * Created by WeiWei on 2017/5/23.
 */
@Component
public class Application implements ApplicationContextAware, ServletContextAware {

    private static ApplicationContext applicationContext;

    private static ServletContext servletContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    @Override
    public void setServletContext(ServletContext context) {
        servletContext = context;
    }

    /**
     * 获取应用名称
     *
     * @return
     */
    public static String getApplicationName() {
        return Application.getValue("${spring.application.name}");
    }

    /**
     * 获取应用IP地址
     *
     * @return
     */
    public static String getHost() {
        return Application.getValue("${spring.cloud.client.ipAddress}");
    }

    /**
     * 获取应用端口号
     *
     * @return
     */
    public static String getPort() {
        return Application.getValue("${server.port}");
    }

    /**
     * 获取配置属性值
     *
     * @param placeHolder
     * @return
     */
    public static String getValue(String placeHolder) {
        return Application.getApplicationContext().getEnvironment().resolvePlaceholders(placeHolder);
    }

    /**
     * 获取Bean
     *
     * @param bean
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> bean) {
        return applicationContext.getBean(bean);
    }

    /**
     * 获取Bean
     *
     * @param bean
     * @param arguments
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> bean, Object... arguments) {
        return applicationContext.getBean(bean, arguments);
    }

    /**
     * 获取Bean
     *
     * @param beanName
     * @param <T>
     * @return
     */
    public static <T> T getBean(String beanName) {
        return (T) applicationContext.getBean(beanName);
    }

    /**
     * 获取Bean
     *
     * @param beanName
     * @param <T>
     * @return
     */
    public static <T> T getBean(String beanName, Object... arguments) {
        return (T) applicationContext.getBean(beanName, arguments);
    }

    /**
     * 发布事件
     *
     * @param event
     */
    public static void publishEvent(ApplicationEvent event) {
        applicationContext.publishEvent(event);
    }

    /**
     * 获取验证器
     *
     * @return
     */
    public static Validator getValidator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    /**
     * 获取用户主要信息
     *
     * @return
     */
    public static Principal getPrincipal() {

        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        return Objects.nonNull(request) && Objects.nonNull(request.getSession()) ? JSONTools.deserialize(String.valueOf(request.getSession().getAttribute(ApplicationDictionary.PRINCIPAL)), Principal.class) : null;

    }

}