package cn.quantgroup.cashloanflowboss.core.base;

import cn.quantgroup.cashloanflowboss.core.dictionary.Status;
import cn.quantgroup.cashloanflowboss.utils.RandomTools;
import lombok.Data;

import java.util.Calendar;
import java.util.Objects;

/**
 * 请求返回数据结构实体类
 * <p>
 * Created by WeiWei on 2017/5/2.
 */
@Data
public class Result<T> {

    /**
     * 返回结果ID
     */
    private String id = RandomTools.getUUID();

    /**
     * 状态码
     */
    private int code;

    /**
     * 描述信息
     */
    private String message;

    /**
     * 响应时间戳
     */
    private long timestamp = Calendar.getInstance().getTimeInMillis();

    /**
     * 返回结果
     */
    private T data;

    public Result() {

    }

    public Result(Status status) {
        this(status, null);
    }

    public Result(Status status, T data) {
        this(status, data, null);
    }

    public Result(Status status, T data, String message) {

        if (Objects.nonNull(status)) {
            this.code = status.getCode();
            this.message = Objects.isNull(message) ? status.getMessage() : message;
            this.data = data;
        }

    }

}
