package cn.quantgroup.cashloanflowboss.core.configuration.data;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

@Configuration
@EntityScan(basePackages = {"cn.quantgroup.cashloanflowboss.api.user.entity.boss"})
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup.cashloanflowboss.api.user.repository.boss"},
        entityManagerFactoryRef = "bossEntityManager",
        transactionManagerRef = "bossTransactionManager")
public class BossDSConfig {

    @Value("${data.boss.url}")
    private String jdbcUrl;

    @Value("${data.boss.password}")
    private String password;

    @Value("${data.boss.username}")
    private String user;

    private String uniquename = "bossDS";

    @Value("${data.boss.pool-size}")
    private Integer poolSize;

    @Primary
    @Bean(name = "bossDataSource")
    @ConfigurationProperties(prefix = "data.boss")
    public DataSource createDataSource() {
        DruidDataSource source = DruidDataSourceBuilder.create().build();
        source.setMaxActive(200);
        source.setMinIdle(10);
        source.setInitialSize(10);
        source.setMaxWait(500000);
        source.setTimeBetweenEvictionRunsMillis(60000);
        source.setMinEvictableIdleTimeMillis(300000);
        source.setValidationQuery("SELECT 'x'");
        source.setTestWhileIdle(true);
        source.setTestOnBorrow(false);
        source.setTestOnReturn(false);
        source.setPoolPreparedStatements(Boolean.FALSE);
        return source;
    }

    @Primary
    @Bean(name = "bossEntityManager")
    public LocalContainerEntityManagerFactoryBean entityManager(EntityManagerFactoryBuilder builder) {

        return builder.dataSource(createDataSource())
                .packages("cn.quantgroup.cashloanflowboss.api.user.entity.boss")
                .persistenceUnit(uniquename)
                .build();
    }

    @Primary
    @Bean(name = "bossTransactionManager")
    public PlatformTransactionManager transactionManager(@Qualifier("bossEntityManager") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

}
