package cn.quantgroup.cashloanflowboss.spi.mo_clotho.service;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.mo_clotho.client.MoClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.model.JsonResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author Wang Xiangwei
 * @version 2020/5/26
 */
@Service
@Slf4j
public class MoClothoServiceImpl implements MoClothoService{

    @Autowired
    private MoClothoCenter moClothoCenter;

    @Override
    public boolean payResultNotify(Long loanId, Boolean expectPayResult) {
        if (Application.isDebug()) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("orderNo", loanId);
            paramMap.put("payOrderNo", loanId);
            paramMap.put("payTime",System.currentTimeMillis());
            paramMap.put("payStatus", expectPayResult ? 3 : 5);
            String result = moClothoCenter.pushLendingResult(paramMap);
            log.info("[放款结果通知]moClotho返回结果result={}", result);
            JsonResult jsonResult = JSONObject.parseObject(result,JsonResult.class);
            return jsonResult.isSuccess();
        } else {
            return false;
        }
    }
}
