package cn.quantgroup.cashloanflowboss.utils;

import cn.quantgroup.user.enums.*;

/**
 * @author Wang Xiangwei
 * @version 2020/7/27
 */
public class EnumInfoUtil {


    public static String Income(IncomeEnum incomeEnum) {
        switch (incomeEnum) {
            case UNKNOWN:
                return incomeEnum.name() + "(未知)";
            case CASH:
                return incomeEnum.name() + "(现金计算)";
            case PAY_CARD:
                return incomeEnum.name() + "(工资卡)";
            case CASH_AND_PAY_CARD:
                return incomeEnum.name() + "(混合)";
        }
        return null;

    }

    public static String incomeRange(IncomeRangeEnum incomeRangeEnum) {
        switch (incomeRangeEnum) {
            case UNKNOWN:return incomeRangeEnum.name()+"(暂无)";
            case BELOW_1000:return incomeRangeEnum.name()+"(小于1000元)";
            case BELOW_3000:return incomeRangeEnum.name()+"(1000至3000元)";
            case BELOW_5000:return incomeRangeEnum.name()+"(3000至5000元)";
            case BELOW_8000:return incomeRangeEnum.name()+"(5000至8000元)";
            case BELOW_10000:return incomeRangeEnum.name()+"(8000至10000元)";
            case BELOW_15000:return incomeRangeEnum.name()+"(10000至15000元)";
            case BELOW_20000:return incomeRangeEnum.name()+"(15000至20000元)";
            case ABOVE_20000:return incomeRangeEnum.name()+"(大于20000元)";
        }
        return null;
    }

    public static String occupation(OccupationEnum occupationEnum) {
        switch (occupationEnum) {
            case UNKNOWN:return occupationEnum.name()+"(暂未填写)";
            case WORKER:return occupationEnum.name()+"(工人)";
            case TEACHER:return occupationEnum.name()+"(教师)";
            case WHITE_COLLAR:return occupationEnum.name()+"(白领)";
            case STUDENT:return occupationEnum.name()+"(学生)";
            case CAREER_BUILDER:return occupationEnum.name()+"(创业者)";
            case SELF_EMPLOYER:return occupationEnum.name()+"(个体户)";
            case EMPLOYEE:return occupationEnum.name()+"(公司职员)";
            case BISUNESS_ENTITY:return occupationEnum.name()+"(企业法人)";
            case ONLINE_STORE_OWNER:return occupationEnum.name()+"(网店店主)";
            case UNEMPLOYED:return occupationEnum.name()+"(暂无职业)";
            case OTHER:return occupationEnum.name()+"(其他)";
        }
        return null;
    }

    public static String education(EducationEnum educationEnum) {
        switch (educationEnum){
            case UNKNOWN:return educationEnum.name()+"(暂无)";
            case MASTER:return educationEnum.name()+"(硕士及以上)";
            case UNDER_GRADUATE:return educationEnum.name()+"(本科)";
            case JUNIOR_COLLEGE:return educationEnum.name()+"(大专)";
            case TECHNICAL_SECONDARY_SCHOOL:return educationEnum.name()+"(中专)";
            case TECHNICAL_SCHOOL:return educationEnum.name()+"(技校)";
            case HIGH_SCHOOL:return educationEnum.name()+"(技校)";
            case MIDDLE_SCHOOL:return educationEnum.name()+"(初中)";
            case PRIMARY_SCHOOL:return educationEnum.name()+"(小学)";
            case OTHER:return educationEnum.name()+"(其他)";

        }
        return null;
    }

    public static String maritalStatus(MaritalStatus maritalStatus) {
        switch (maritalStatus){
            case UNKNOWN:return maritalStatus.name()+"(未知)";
            case SINGLE:return maritalStatus.name()+"(未婚)";
            case MARRIED:return maritalStatus.name()+"(已婚)";
            case DIVORCED:return maritalStatus.name()+"(离异)";
            case WINDOWED:return maritalStatus.name()+"(丧偶)";
            case OTHER:return maritalStatus.name()+"(其他)";

        }
        return null;
    }

}
