package cn.quantgroup.cashloanflowboss.spi.mo_clotho.service;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.mo_clotho.client.MoClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.model.JsonResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

/**
 * @author Wang Xiangwei
 * @version 2020/5/26
 */
@Service
@Slf4j
public class MoClothoServiceImpl implements MoClothoService{

    @Autowired
    private MoClothoCenter moClothoCenter;

    @Override
    public boolean payResultNotify(Long loanId, Boolean expectPayResult) {
        if (Application.isDebug()) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("orderNo", loanId);
            paramMap.put("payOrderNo", loanId);
            paramMap.put("payTime",System.currentTimeMillis());
            paramMap.put("payStatus", expectPayResult ? 3 : 4);
            String result = moClothoCenter.pushLendingResult(paramMap);
            log.info("[放款结果通知]moClotho返回结果result={}", result);
            //JsonResult jsonResult = JSONObject.parseObject(result,JsonResult.class);
            //return jsonResult.isSuccess();
            return Objects.nonNull(result) && "success".equalsIgnoreCase(result);
        } else {
            return false;
        }
    }

    @Override
    public boolean secondAuditNotice(Long loanId) {
        if (Application.isDebug()) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("loanId", loanId);
            JsonResult result = moClothoCenter.secondAuditNotice(paramMap);
            log.info("[二次风控审批结果通知]moClotho返回结果result={}", result);
            return Objects.nonNull(result) && "0".equals(result.getCode());
        } else {
            return false;
        }
    }

}
