package cn.quantgroup.cashloanflowboss.api.user.model;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

@Data
public class UserDetailInfo {
    private UserInfo userInfo;
    private RoleInfo roleInfo;
    private Long channelId;
    private String rank;


    @Data
    static class RoleInfo {
        List<RoleView> roleInfos;

        @Data
        static class RoleView {
            private Long roleId;
            private String roleName;
        }
    }

    public static UserDetailInfo valueOf(Principal principal) {
        Assert.isNull(principal, ApplicationStatus.INVALID_USER);
        UserDetailInfo userDetailInfo = new UserDetailInfo();
        Long userId = principal.getUserInfo().getUserId();
        userDetailInfo.setRank(principal.getRank().name());
        userDetailInfo.setChannelId(principal.getChannelId());
        List<Role> roles = principal.getRoles();


        if (null != roles && roles.size() > 0) {
            RoleInfo roleInfo = new RoleInfo();
            List<RoleInfo.RoleView> roleInfos = Lists.newArrayList();
            roles.forEach(role -> {
                RoleInfo.RoleView roleView = new RoleInfo.RoleView();
                roleView.setRoleId(role.getId());
                roleView.setRoleName(role.getName());
                roleInfos.add(roleView);
            });
            roleInfo.setRoleInfos(roleInfos);
            userDetailInfo.setRoleInfo(roleInfo);
        }

        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(userId);
        userInfo.setNickname(principal.getUserInfo().getNickname());
        userInfo.setUsername(principal.getUserInfo().getUsername());
        userDetailInfo.setUserInfo(userInfo);

        return userDetailInfo;
    }


}
