package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.FundsAllocationplanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.LoanOperationService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.LoanApplicationHistoryRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.WaitingFundingCorpOperatePeopleRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.service.XYQBCenterService;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class LoanOperationServiceImpl implements LoanOperationService{

    @Autowired
    private LoanApplicationHistoryRepository loanApplicationHistoryRepository;
    @Autowired
    private XYQBCenterService xyqbCenterService;
    @Autowired
    private WaitingFundingCorpOperatePeopleRepository waitingFundingCorpOperatePeopleRepository;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private LoanOperationService loanOperationService;
    @Autowired
    private FundsAllocationplanService fundsAllocationplanService;
    @Value("${opapi.http.net}")
    private String opapiHttp;
    @Value("${clotho.http.net}")
    private String clothoHttp;
    @Value("${api.http.net}")
    private String apiHttp;
    @Override
    public Result applyLoanNotify(OneClickData oneClickData) {

        return null;
    }

    @Override
    public LoanApplicationHistory selectLoanId(Long userId,Integer businessType) {
       return loanApplicationHistoryRepository.findByUserIdAndBusinessTypeAndIsActive(userId,businessType);
    }

    /**
     * 二次风控
     * */
    @Override
    public JSONObject orderAuditNotify(OneClickData oneClickData) {
        String url= clothoHttp+"/external/quota/order_audit/notify";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel","1");
        paras.put("uuid", oneClickData.getUuid());
        paras.put("bizNo",oneClickData.getLoanId());
        paras.put("bizType",oneClickData.getBizType().toString().trim());
        paras.put("auditResult","true" );
        paras.put("deadLine", "1548518400");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", oneClickData.getToken());
        log.info("打印当前的二次风控paras={},header={}",paras,header);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);


        return result;
    }

    @Override
    public boolean updatContractStatus(OneClickData oneClickData) {
        boolean boo=true;
        int num=xyqbCenterService.updateContractStatus(Long.valueOf(oneClickData.getUserId()),2,Long.valueOf(oneClickData.getLoanId()));
        if(num>0){

        }else{
            boo=false;

        }
        return boo;
    }





    /**
     * 查询放款记录
     *
     * @param fundId
     * @return Map
     */
    @Override
    public Map queryLendingRecordCount(Long fundId) {
        return xyqbCenterService.queryLendingRecordCount(fundId);
    }

    /**
     * 查询放款记录总数
     *
     * @param fundId
     * @return Long
     */
    @Override
    public Long queryLendingRecordSumCount(Long fundId) {
        return xyqbCenterService.queryLendingRecordSumCount(fundId);
    }

    /**
     * 查询放款记录金额总数
     *
     * @param fundId
     * @return BigDecimal
     */
    @Override
    public BigDecimal queryLendingRecordAmountMountSumCount(Long fundId) {
        return xyqbCenterService.queryLendingRecordAmountMountSumCount(fundId);
    }



    @Override
    public int updatWaitingFundingCorpOperatePeopleCreaterTime(Long fundID) {
        int num=waitingFundingCorpOperatePeopleRepository.updateByLoanApplicationHistoryId(fundID);
        if (num>0){
            log.info("成功修改数据");
        }else{
            log.info("没有找到对应的放款单");
        }
        return num;
    }



    @Override
    public JSONObject fundsPlanLoanApply(OneClickData oneClickData,String payStatus) {

            // 查看当前的放款单的状态是21
            LoanApplicationHistory loanApplicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());
            String progress=loanApplicationHistory.getProgress().getDescription().trim();
            if(LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().trim().equals(progress) ){
               //系统自动打款，无需调用打款操作
                return  payNotify(oneClickData, payStatus);
            }else{
                oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.DIRECT_INVESTMENT_FAILURE.getCode(), oneClickData.getId());

            }

       return isFundsPlanLoanApply(oneClickData, payStatus);


        }

    public JSONObject isFundsPlanLoanApply(OneClickData oneClickData,String payStatus){
              String url= opapiHttp+"/clotho/funds/plan/loan/apply";
        log.info("打印一下oneClickData.getFundCorpId()={}", oneClickData.getFundCorpId());
        // 判断当前是否有需要放款的数量和人
        String amountLimit="";
        String assignPeopleNum="";
        BigDecimal AmountMountSumCount=queryLendingRecordAmountMountSumCount(Long.parseLong(oneClickData.getFundCorpId()));
        Long sumCount=queryLendingRecordSumCount(Long.parseLong(oneClickData.getFundCorpId()));
       if(Objects.isNull(AmountMountSumCount) || Objects.isNull(sumCount) ){
           log.info("获取sql金额为AmountMountSumCount={}，sumCount={}",AmountMountSumCount,sumCount);
           return payNotify(oneClickData, payStatus);
       }else {

           // 如有有需要提现操作的单，进行提现操作
           amountLimit = AmountMountSumCount.toString().trim();
           assignPeopleNum = sumCount.toString().trim();
           String fundCorpId = oneClickData.getFundCorpId();
           Map<String, String> paras = new HashMap<String, String>();
           paras.put("fundingCorpId", fundCorpId);
           paras.put("amountLimit", amountLimit.substring(0, 5));
           paras.put("peopleLimit", assignPeopleNum);
           Map<String, String> header = new HashMap();
           header.put("Content-Type", "application/x-www-form-urlencoded");
           header.put("x-auth-token", fundsAllocationplanService.loginOPToken());
           JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
           String businessCode=result.get("businessCode").toString().trim();
           String code=result.get("code").toString().trim();
           if ("0000".equals(businessCode) && "0000".equals(code)) {
               // 需要咨询这个接口
               // 待续中。。。。。。

               if (!fundCorpId.equals("210")) {
                   // 查看当前的放款单的状态是21
                   LoanApplicationHistory loanApplicationHistory = loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType());
                   log.info("放款通知请求完毕后loanApplicationHistory={}", loanApplicationHistory);
                   String progress=loanApplicationHistory.getProgress().getDescription().trim();
                   if (progress.equals(LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().trim())) {
                       //直投打款完毕进行放款操作
                       return payNotify(oneClickData, payStatus);
                   } else {
                       oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.DIRECT_INVESTMENT_FAILURE.getCode(), oneClickData.getId());

                   }

               }
           } else {
               // 发起提现失败
               oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.DIRECT_INVESTMENT_FAILURE.getCode(), oneClickData.getId());
               return result;
           }

       }
        return null;
    }


    /**
     * 放款结果通知
     * */
    @Override
    public JSONObject payNotify(OneClickData oneClickData,String payStatus) {

        String url=apiHttp+"/ex/paycenter/pay_notify";

        long payTime=System.currentTimeMillis();
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("orderNo",oneClickData.getLoanId() );
        paras.put("payOrderNo",oneClickData.getLoanId() );
        paras.put("payTime", String.valueOf(payTime));
        paras.put("payStatus", payStatus);
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        return result;
    }
}
