package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ResposeResultEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.GuangDaXiaoDaiService;
import cn.quantgroup.cashloanflowboss.spi.gyxd.entity.LoanApplicationManifestHistory;
import cn.quantgroup.cashloanflowboss.spi.gyxd.repository.ILoanApplicationManifestHistoryRepository;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.testng.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/20.
 */
public class GuangDaXiaoDaiServiceImpl implements GuangDaXiaoDaiService {
    @Autowired
    private ILoanApplicationManifestHistoryRepository loanApplicationManifestHistoryRepository;
    @Value("{gyxdapi.http.net}")
    private String gyxdHttp;
    @Override
    public LoanApplicationManifestHistory selectLoanApplicationManifestHistory(String loanId) {
        return loanApplicationManifestHistoryRepository.findByLoanId(loanId);
    }

    @Override
    public int updateGYXDStatusOf3(String loanId,int loanProgress ) {
        int num=loanApplicationManifestHistoryRepository.updateLoanProgress(loanId,loanProgress);
        if (num>0){
            return num;
        }else {
            return 0;
        }

    }

    @Override
    public String getGyxdToken() {
        String url=gyxdHttp+"/ex/user/login";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("account","user1");
        paras.put("password", "Gyxd2018");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        if(!result.get("data").toString().trim().isEmpty()) {

            JSONObject resultData = (JSONObject) result.get("data");
            String businessCode=result.get("businessCode").toString().trim();
            if(ResposeResultEnum.BUSINESSCODE.getDesc().equals(businessCode)){
                return resultData.get("token").toString().trim();

            }else {
                return "";
            }

        }else{
            Assert.assertEquals("没有获取到resultData", "000");
            return "";
        }
    }

    @Override
    public JSONObject GuangYuanXiaoDaiBatchDeal(String loanID ) {
        String url= gyxdHttp+"/ex/loan/batch_deal";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("loanIds",loanID);
        paras.put("step", "CALLBACK");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", getGyxdToken());
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("statusCode").toString().trim(), "200");
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        return result;
    }
}
