package cn.quantgroup.cashloanflowboss.utils;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ChannelEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.CreditStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/18.
 */
@Slf4j
public class GetEncryptContentAndMd5 {
    /**
     * 加密加签
     * @param paras
     * @param aesKeywy
     * @param md5Keywy
     * @return
     */
    public static String  getEncryptContent(Object paras, String aesKeywy, String md5Keywy) {

        String acs_url = "http://acs.liangkebang.com/encryptAndBase64Encode";
        Map<String,String> para8 = new HashMap<String, String>();

        final String bizData = JSONObject.toJSONString(paras);
        Map<String,String> contentMap= new HashMap<String, String>();
        contentMap.put("bizData", bizData);
        contentMap.put("sign", md5(bizData.concat(md5Keywy)));


        para8.put("content", JSONObject.toJSONString(contentMap));
        para8.put("key",aesKeywy);
        Map<String,String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject content = HttpRequest.doPostReturnResponseJson(acs_url, para8, header);


        String contentStr = content.get("context").toString();
        log.info("查看结果={}", contentStr);
        return contentStr;
    }


    /**
     * 加密加签
     * @param paras
     * @param aesKeywy
     * @param md5Keywy
     * @return
     */
    public static String  getEncryptContent(String paras, String aesKeywy, String md5Keywy) {

        String acs_url = "http://acs.liangkebang.com/encryptAndBase64Encode";
        Map<String,String> para8 = new HashMap<String, String>();
        final String bizData =  paras;
        Map<String,String> contentMap= new HashMap<String, String>();
        contentMap.put("bizData", bizData);
        contentMap.put("sign", md5(bizData.concat(md5Keywy)));


        para8.put("content", JSONObject.toJSONString(contentMap));
        para8.put("key",aesKeywy);
        Map<String,String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject content = HttpRequest.doPostReturnResponseJson(acs_url, para8, header);


        String contentStr = content.get("context").toString();
        log.info("查看结果={}", contentStr);
        return contentStr;
    }


    public static String md5(String content) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("md5");
        } catch (NoSuchAlgorithmException e) {
            log.info(e.getMessage(), e);
            return null;
        }
        messageDigest.update(content.getBytes());
        byte[] domain = messageDigest.digest();
        StringBuilder md5StrBuff = new StringBuilder();
        // converting domain to String
        for (int i = 0; i < domain.length; i++) {
            if (Integer.toHexString(0xFF & domain[i]).length() == 1) {
                md5StrBuff.append("0").append(
                        Integer.toHexString(0xFF & domain[i]));
            } else {
                md5StrBuff.append(Integer.toHexString(0xFF & domain[i]));
            }
        }
        return md5StrBuff.toString();

    }

    public static String  getChannelName(String channel){
        for(ChannelEnum channelEnum:ChannelEnum.values()){
            if(channel.equals(channelEnum.getCode())){
                return channelEnum.getDesc();
            }
        }
        return "";
    }


    public static String  getLoanMessage(int loanCode){
        for(LoanStatusEnum loanStatusEnum:LoanStatusEnum.values()){
            if(loanCode == loanStatusEnum.getCode()){
                return loanStatusEnum.getDesc();
            }
        }
        return "";
    }

    public static String  getCreditMessage(int creditCode){
        for(CreditStatusEnum creditStatusEnum:CreditStatusEnum.values()){
            if(creditCode == creditStatusEnum.getCode()){
                return creditStatusEnum.getDesc();
            }
        }
        return "";
    }


    public static void main(String[] arg){
       String channelName= getChannelName("159858");
        System.out.print("打印渠道名称： "+channelName);
    }

}
