package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.api.order.model.RepaymentPlansResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.*;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Map;

/**
 * function:
 * date: 2019/9/27
 *
 * @author: suntao
 */
public interface XYQBCenterService {

    int updateContractStatus(Long userId, Integer status);

    Map queryLendingRecordCount(Long fundId);

    Long cancelPreLoan(String channelOrderNumber);

    Contract findContractByUserId(Long userId);

    void saveContract(Contract contract);

    WaitingFundingCorpOperatePeople findWaitingFundingCorpOperatePeopleByLoanId(Long loanId);

    @Transactional(rollbackOn = Exception.class)
    void saveWaitingFundingCorpOperatePeople(WaitingFundingCorpOperatePeople waitingFundingCorpOperatePeople);

    FundingCorpPolicy findFundingCorpPolicyByCorpPolicyId(Long corpPolicyId);

    FundingAssetAllocationsPrograms findFundingAssetAllocationsProgramsByCorpPolicyIdAndPlanDate(Long corpPolicyId, String planDate);

    LoanApplicationHistory findLoanApplicationHistoryById(Long loanId);

    Boolean validateCorpPolicy(Long corpPolicyId, Date planDate);

    QuotaProduct getXyqbProduct(String productId);

    ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getXyqbOrderStatus(String creditOrderNumber, Long loanId);

    ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(String creditOrderNumber, Long loanId);

    boolean payResultNotify(Long loanId, Boolean expectPayResult);

    Tuple<Boolean,String> cleanUserActiveOrder(Long userId);

    ServiceResult<RepaymentPlansResultModel> findRepaymentPlan(Long loanId);
}
