package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.WaitingFundingCorpOperatePeople;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@XYQBDataSource
@Repository
public interface WaitingFundingCorpOperatePeopleRepository extends CrudRepository<WaitingFundingCorpOperatePeople, Long>, JpaRepository<WaitingFundingCorpOperatePeople, Long> {


    /**
     * 查询待放款记录
     *
     * @param fundId
     * @return
     */
    @Query(value = "select sum(fund_amount) ,count(*) from xyqb.waiting_funding_corp_operate_people where funding_corp_progress=0  and funding_corp_id= ?1", nativeQuery = true)
    Map queryLendingRecordCount(Long fundId);

    WaitingFundingCorpOperatePeople findByLoanApplicationHistoryId(Long loanId);

}