package cn.quantgroup.cashloanflowboss.spi.user.service;

import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.user.bean.UserInfo;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;


/**
 * Created by Rocky on 2016/6/23.
 */
public interface XyqbUserService {



    /**
     *  查询用户
     */
    XUser findXUserById(Long userId);

    /**
     *  查询用户detail
     */
    XUserDetail findUserDetailByUserId(Long userId);

    /**
     * get uuid
     * @param phoneNo 手机号
     * @return String token
     */
    String getUuid(String phoneNo);

    /**
     * 通过手机号码 查询xyqb-user
     * @param phoneNo
     * @return
     */
    XUser findUserByPhoneNo(String phoneNo);

    /**
     * 判断是否老用户
     * @param phoneNo 手机号
     * @return 老用户 true；新用户 false
     */
    boolean isOldUser(String phoneNo);


    /**
     * 用户detail信息
     * @param uuid
     * @return
     */
    UserInfo findUserByUuid(String uuid);


    /**
     * 删除记录
     */
    Tuple<Boolean,String> deleteByUserId(String phoneNo);
}
