package cn.quantgroup.cashloanflowboss.spi.user.service;

import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneService;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneUtil;
import cn.quantgroup.cashloanflowboss.spi.jolyne.model.JolyneDB;
import cn.quantgroup.cashloanflowboss.spi.user.repository.UserDetailRepository;
import cn.quantgroup.cashloanflowboss.spi.user.repository.UserExtInfoRepository;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import cn.quantgroup.user.bean.UserInfo;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.user.vo.UserSysResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by Rocky on 2016/6/23.
 */
@Service
public class XyqbUserServiceImpl implements XyqbUserService {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(XyqbUserServiceImpl.class);

    @Autowired
    private UserSysService userSysService;
    @Autowired
    private UserDetailRepository userDetailRepository;
    @Autowired
    private UserExtInfoRepository userExtInfoRepository;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value("${passportapi.http}")
    private String passportapiHttp;
    @Autowired
    private JolyneService jolyneService;



    /**
     * 查询用户
     *
     * @param userId
     * @return XyqbUser
     */
    @Override
    public XUser findXUserById(Long userId) {
        UserSysResult<XUser> userSysResult = userSysService.getService().findUserByUserId(userId);
        if (!userSysResult.isSuccess() || userSysResult.getData() == null) {
            LOGGER.error("用户不存在，userId=[{}]", userId);
            return null;
        }
        return userSysResult.getData();
    }


    @Override
    public XUserDetail findUserDetailByUserId(Long userId) {
        UserSysResult<XUserDetail> userDetailResult = userSysService.getService().findUserDetailByUserId(userId);
        if (!userDetailResult.isSuccess() || userDetailResult.getData() == null) {
            LOGGER.error("[findUserDetailByUserId_{}]向用户中心查询用户详情失败,userId={},result={}", userId, JSONTools.serialize(userDetailResult));
            return null;
        }
        return userDetailResult.getData();
    }

    @Override
    public String getUuid(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) {
            return null;
        }
        UserSysResult<XUser> user = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (Objects.isNull(user) || Objects.isNull(user.getData())) {
            return null;
        }
        return user.getData().getUuid();
    }

    @Override
    public XUser findUserByPhoneNo(String phoneNo) {
        UserSysResult<XUser> xuserResult = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (xuserResult == null || xuserResult.getData() == null || !xuserResult.isSuccess()) {
            LOGGER.info("[findUserByPhoneNo]用户中心无用户信息,phoneNo={}，phoneDd5={}", phoneNo, MD5Tools.md5(phoneNo));
            return null;
        }
        return xuserResult.getData();
    }


    /**
     * 判断是否老用户
     *
     * @param phoneNo 手机号
     * @return 老用户 true；新用户 false
     */
    @Override
    public boolean isOldUser(String phoneNo) {
        UserSysResult<XUser> userData = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (userData == null) {
            LOGGER.error("[user_isOldUser]查询用户失败, phoneNo={}", phoneNo);
            return false;
        }
        if (userData.getData() == null) {
            LOGGER.info("[user_isOldUser]没有查询到用户, phoneNo={}", phoneNo);
            return false;
        } else {
            return true;
        }
    }

    @Override
    public UserInfo findUserByUuid(String uuid) {
        UserSysResult<UserInfo> userInfo = userSysService.getService().findUserInfoByUuid(uuid);
        if (!userInfo.isSuccess() || userInfo.getData() == null) {
            return null;
        }
        return userInfo.getData();
    }


    //@OperationAnno(channelNo = "#this[0]", opt = OptEnumName.USER_INFO_CLEAN, succSPEL = "#this.key", optDetailSPEL = "#this.value")
    @Async("commonAsyncExecutor")
    @Override
    public Tuple<Boolean,String> deleteByUserId(String phoneNo) {
        try{
            UserSysResult<XUser> xUser = userSysService.getService().findUserByPhoneNo(phoneNo);
            if (xUser == null || xUser.getData() == null) {
                LOGGER.error("cleanUserOrder,删除用户信息失败，未找到用户 phoneNo={}", phoneNo);
                return new Tuple<>(false,"删除用户信息失败，未找到用户");
            }
            Long userId = xUser.getData().getId();
            ArrayList<String> cancelList = Lists.newArrayList();
            cancelList.add("delete from user_detail where user_id=" + userId);
            cancelList.add("delete from user_ext_info where user_id=" + userId);
            cancelList.add("delete from contact where user_id=" + userId);
            cancelList.add("delete from address where user_id=" + userId);

            String cancelResult = jolyneService.executeSQL(JolyneDB.XYQB_USER, JolyneUtil.getJolneSql(cancelList));
            JSONObject resp = JSONObject.parseObject(cancelResult);

            Set<String> phoneNoKeys = redisTemplate.keys(phoneNo);
            if(phoneNoKeys!=null){
                redisTemplate.delete(phoneNoKeys);
            }
            Set<String> userKeys = redisTemplate.keys(String.valueOf(userId));
            if(userKeys!=null){
                redisTemplate.delete(userKeys);
            }
            String tokenKey = "userid-sessionvalue:cache::"+userId+":xyqb";
            String token = redisTemplate.opsForValue().get(tokenKey);
            if(token!=null && redisTemplate.keys(token)!=null){
                Set<String> tokenKeys = redisTemplate.keys(token);
                redisTemplate.delete(tokenKeys);
            }
        }catch (Exception e){
            LOGGER.error("cleanUserOrder,删除用户信息失败，phoneNo={}", phoneNo);
            return new Tuple<>(false,"删除用户信息失败");
        }
        return new Tuple<>(true,"删除用户信息成功");
    }
}
