package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.spi.model.JsonResult;
import cn.quantgroup.cashloanflowboss.spi.util.HttpService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.model.ProductUtil;
import cn.quantgroup.cashloanflowboss.spi.xyqb.model.QuotaCreditInfo;
import cn.quantgroup.cashloanflowboss.spi.xyqb.model.QuotaInfo;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;

/**
 *
 * @author abe
 * @Date 20180105
 */
@Service
public class XyqbService {

//    private static final Logger LOGGER = LoggerFactory.getLogger(XyqbService.class);
//
//    @Value("${api.http}")
//    private String xyqbUrl;
//
//    @Autowired
//    private HttpService httpService;
//
////    @Override
////    public String queryXyqbForData(String interfaceUrl , Map<String, String> param){
////        try{
////            LOGGER.info("[KA_INVOKE_XYQB][queryXyqbForData]开始调用查询xyqb库接口，路径是={}，参数是={}", interfaceUrl, param);
////            return httpService.get(xyqbUrl+interfaceUrl,param);
////        }catch(Exception e){
////            LOGGER.error("[exception][KA_INVOKE_XYQB][queryXyqbForData]调用xyqb接口查询出现异常，接口路径={}，参数是={}", interfaceUrl, param, e);
////            return  null;
////        }
////    }
////
////    @Override
////    public String postXyqbSaveData(String interfaceUrl , Map<String, String> param){
////        try{
////            LOGGER.info("[postXyqbSaveData]开始调用查询xyqb库接口，路径是={}，参数是={}", interfaceUrl, param);
////            return httpService.post(xyqbUrl+interfaceUrl,param);
////        }catch(Exception e){
////            LOGGER.error("[exception][KA_INVOKE_XYQB][postXyqbSaveData]调用xyqb接口查询出现异常，接口路径={}，参数是={}", interfaceUrl, param, e);
////            return  null;
////        }
////    }
//
//
//    /** 关闭授信订单 */
//    public boolean closeCreditLoan(Long userId, String applyNo) {
//        String url = String.valueOf(xyqbUrl + "/ex/ka/quota/credit/close");
//        Map<String, String> param = new HashMap<>(4);
//        param.put("userId", String.valueOf(userId));
//        param.put("orderNo", applyNo);
//        String result = httpService.post(url, param);
//        JsonResult jsonResult = JSONTools.deserialize(result, JsonResult.class);
//        if (jsonResult != null && jsonResult.isSuccess()) {
//            return true;
//        } else {
//            LOGGER.error("[closeCreditLoan][closeCreditLoan_fail]授信订单关闭失败,userId={},applyNo={}", userId, applyNo);
//            return false;
//        }
//    }
//
//    /**
//     * 查询额度创建之后的详细信息
//     * @param userId
//     * @param registeredFrom
//     * @return
//     */
//    public Optional<QuotaInfo> queryQuotaInfo(Long userId, Long registeredFrom) {
//        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/info");
//        final Map<String, String> param = new HashMap<>(4);
//        param.put("userId", String.valueOf(userId));
//        param.put("productId", ProductUtil.getProductId(registeredFrom));
//
//        final String result = httpService.get(url, param);
//        TypeReference<JsonResult<QuotaInfo>> typeReference = new TypeReference<JsonResult<QuotaInfo>>() {};
//        JsonResult<QuotaInfo> jsonResult = JSONTools.deserialize(result, typeReference);
//        if (jsonResult != null && jsonResult.isSuccess()) {
//            QuotaInfo quotaInfo = jsonResult.getData();
//            if (QuotaInfo.validationQuotaInfo(quotaInfo)) {
//                return Optional.ofNullable(quotaInfo);
//            } else {
//                LOGGER.error("[queryQuotaInfo_{}][queryQuotaInfo_fail]授信订单查询结果未通过验证,userId={},result={}",registeredFrom, userId, result);
//                return Optional.empty();
//            }
//        }
//        LOGGER.error("[queryQuotaInfo_{}][queryQuotaInfo_fail]授信订单结果查询失败,userId={},result={}",registeredFrom, userId, result);
//        return Optional.empty();
//    }
//
//    public Optional<QuotaCreditInfo> queryQuotaCreditInfo(String orderNo) {
//        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/credit-info");
//        final Map<String, String> param = new HashMap<>(2);
//        param.put("orderNo", orderNo);
//
//        final String result = httpService.get(url, param);
//
//        TypeReference<JsonResult<QuotaCreditInfo>> typeReference = new TypeReference<JsonResult<QuotaCreditInfo>>() {};
//        JsonResult<QuotaCreditInfo> jsonResult = JSONTools.deserialize(result, typeReference);
//        if (jsonResult != null && jsonResult.isSuccess()) {
//            return Optional.ofNullable(jsonResult.getData());
//        } else {
//            LOGGER.error("[queryQuotaCreditInfo_{}][queryQuotaCreditInfo_fail]授信订单结果查询失败,orderNo={},result={}", orderNo, result);
//            return Optional.empty();
//        }
//    }
////
////    public Optional<QuotaCreditInfo> queryQuotaCreditInfo(Long loanId) {
////        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/loan/credit");
////        final Map<String, String> param = new HashMap<>(2);
////        param.put("loanId", String.valueOf(loanId));
////
////        final String result = httpService.get(url, param);
////        final Type type = new TypeToken<JsonResultGenericData<QuotaCreditInfo>>() {}.getType();
////        Optional<JsonResultGenericData<QuotaCreditInfo>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
////        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
////            return Optional.ofNullable(jsonResultOptional.get().getData());
////        } else {
////            LOGGER.error("[queryQuotaCreditInfo_{}][queryQuotaCreditInfo_fail]授信订单结果查询失败,loanId={},result={}", loanId, result);
////            return Optional.empty();
////        }
////    }
//
//
//
//    /**
//     * 查询订单终态
//     * @param applyNo
//     * @param loanId
//     * @return
//     */
//    @Override
//    public FinalStatusResponse queryFinalStatus(String applyNo, Long loanId) {
//        FinalStatusResponse finalStatusResponse = new FinalStatusResponse();
//
//
//        if (LoanUtil.isQuotaLoanId(loanId)) {
//            final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/loan/final/status");
//            final Map<String, String> param = new HashMap<>(2);
//            param.put("loanId", String.valueOf(loanId));
//
//            final String result = httpService.get(url, param);
//            LOGGER.info("[queryFinalStatus_{}][queryFinalStatus]订单终态查询,loanId={},result={}", loanId, result);
//            final Type type = new TypeToken<JsonResultGenericData<FinalStatusResponse.QueryXyqbFinalStatusResponse>>() {}.getType();
//            Optional<JsonResultGenericData<FinalStatusResponse.QueryXyqbFinalStatusResponse>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
//            if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//                final FinalStatusResponse.QueryXyqbFinalStatusResponse data = jsonResultOptional.get().getData();
//                if (data != null) {
//                    finalStatusResponse.setStatus(FinalStatusEnum.getFinalStatusEnum(data.getStatus()));
//                    finalStatusResponse.setUpdatedAt(DateUtil.dateStr2Date(data.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
//                    return finalStatusResponse;
//                }
//            }
//        } else {
//            if (StringUtils.isNotEmpty(applyNo)) {
//                Optional<QueryCheckResultResponse> queryCheckResultResponseOptional = queryCheckResultStatus(applyNo);
//                if (queryCheckResultResponseOptional.isPresent()) {
//                    QueryCheckResultResponse queryCheckResultResponse = queryCheckResultResponseOptional.get();
//                    finalStatusResponse.setStatus(FinalStatusEnum.getFinalStatusEnum(queryCheckResultResponse.getStatus()));
//                    finalStatusResponse.setUpdatedAt(DateUtil.dateStr2Date(queryCheckResultResponse.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
//                    return finalStatusResponse;
//                }
//            }
//        }
//        LOGGER.error("[queryFinalStatus][queryFinalStatus_default]订单终态查询,未查询到终态,loanId={},applyNo={}", loanId, applyNo);
//        finalStatusResponse.setStatus(FinalStatusEnum.UNKNOWN);
//        finalStatusResponse.setUpdatedAt(new Date());
//        return finalStatusResponse;
//    }
//
//    @Override
//    public Optional<QueryXyqbFundStatusResponse> queryFundStatus(Long loanId) {
//        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/fund/status");
//        final Map<String, String> param = new HashMap<>(2);
//        param.put("loanId", String.valueOf(loanId));
//
//        final String result = httpService.get(url, param);
//        LOGGER.info("[queryFundStatus_{}][queryFundStatus]放款状态查询,loanId={},result={}", loanId, result);
//        final Type type = new TypeToken<JsonResultGenericData<QueryXyqbFundStatusResponse>>() {}.getType();
//        Optional<JsonResultGenericData<QueryXyqbFundStatusResponse>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
//        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//            return Optional.ofNullable(jsonResultOptional.get().getData());
//        } else {
//            LOGGER.error("[queryFundStatus_{}][queryFundStatus_fail]放款状态查询失败,loanId={},result={}", loanId, result);
//            return Optional.empty();
//        }
//    }
//
//    /**
//     * 查询该笔授信订单 目前状态
//     * @param applyNo
//     * @return
//     */
//    @Override
//    public Optional<QueryCheckResultResponse> queryCheckResultStatus(String applyNo) {
//        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/current/status");
//        final Map<String, String> param = new HashMap<>(2);
//        param.put("orderNo", applyNo);
//
//        final String result = httpService.get(url, param);
//        LOGGER.info("[queryCheckResultStatus_{}][queryCheckResultStatus]查询审批状态,applyNo={},result={}", applyNo, result);
//        final Type type = new TypeToken<JsonResultGenericData<QueryCheckResultResponse>>() {}.getType();
//        Optional<JsonResultGenericData<QueryCheckResultResponse>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
//        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//            return Optional.ofNullable(jsonResultOptional.get().getData());
//        } else {
//            LOGGER.error("[queryCheckResultStatus_{}][queryCheckResultStatus_fail]查询审批状态失败,applyNo={},result={}", applyNo, result);
//            return Optional.empty();
//        }
//    }
//
//    @Override
//    public Optional<QuotaRepaymentPreview> queryQuotaPreviewByFirstTerm(Long userId, Long productId, BigDecimal totalAmount, Integer term){
//        List<QuotaRepaymentPreview> quotaRepaymentPreviews = trialRepaymentPlan(String.valueOf(userId), String.valueOf(productId), Constants.DECIMAL_FORMAT0.format(totalAmount), String.valueOf(term));
//        if (CollectionUtils.isNotEmpty(quotaRepaymentPreviews)) {
//            return Optional.ofNullable(quotaRepaymentPreviews.get(0));
//        } else {
//            return Optional.empty();
//        }
//    }
//
//    @Override
//    public Optional<PaymentBusinessInfo> queryPaymentBusinessInfo(Long loanId, Long channelId) {
//        String url = String.valueOf(xyqbUrl + "/ex/ka/xiaoniu/card");
//        Map<String, String> param = new HashMap<>(4);
//        param.put("loanId", String.valueOf(loanId));
//        param.put("channel", String.valueOf(channelId));
//        String result = httpService.get(url, param);
//        Optional<JsonResult> jsonResultOptional = JsonUtil.fromJson(result, JsonResult.class);
//        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//            LOGGER.info("[queryPaymentBusinessInfo]查询放款信息,loanId={},result={}",loanId, result);
//            PaymentBusinessInfo paymentBusinessInfo = new PaymentBusinessInfo();
//            paymentBusinessInfo.setPaymentAccount(String.valueOf(jsonResultOptional.get().getData()));
//            return Optional.ofNullable(paymentBusinessInfo);
//        } else {
//            LOGGER.error("[queryPaymentBusinessInfo][queryPaymentBusinessInfo_fail]查询放款卡信息,loanId={},result={}",loanId, result);
//            return Optional.empty();
//        }
//    }
//
//    @Override
//    public JsonResult applyQuitCourse(String applyNo, Long loanId, Long channelId) {
//        String url = String.valueOf(xyqbUrl + "/ex/ka/xiaoniu/drop_course");
//        Map<String, String> param = new HashMap<>(4);
//        param.put("loanId", String.valueOf(loanId));
//        param.put("channel", Objects.toString(channelId));
//        param.put("orderNo", applyNo);
//        String result = httpService.post(url, param);
//        Optional<JsonResult> jsonResultOptional = JsonUtil.fromJson(result, JsonResult.class);
//        if (jsonResultOptional.isPresent()) {
//            LOGGER.info("[xiaoniu_applyQuitCourse]小牛在xyqb 申请退课,loanId={},applyNo={},result={}",loanId, applyNo, result);
//            return jsonResultOptional.get();
//        } else {
//            LOGGER.error("[xiaoniu_applyQuitCourse][xiaoniu_applyQuitCourse_fail]小牛在xyqb 申请退课请求异常,loanId={},applyNo={},result={}",loanId, applyNo, result);
//            return JsonResult.buildEmptyStateResult("系统异常");
//        }
//    }
//
//    @Override
//    public Optional<DepositoryBusiness> queryDepositoryBusiness(String applyNo, Long loanId) {
//        String url = String.valueOf(xyqbUrl + "/ex/ka/fund/withdraw");
//        Map<String, String> param = new HashMap<>(2);
//        param.put("loanId", String.valueOf(loanId));
//        String result = httpService.get(url, param);
//        Type type = new TypeToken<JsonResultGenericData<DepositoryBusiness>>() {}.getType();
//        Optional<JsonResultGenericData<DepositoryBusiness>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
//        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//            LOGGER.info("[queryDepositoryBusiness]查询存管状态,loanId={},result={}",loanId, result);
//            return Optional.ofNullable(jsonResultOptional.get().getData());
//        } else {
//            LOGGER.error("[queryDepositoryBusiness][paymentAndBindCard_fail]查询存管状态,loanId={},result={}",loanId, result);
//            return Optional.empty();
//        }
//    }
//
//    @Override
//    public List<QuotaRepaymentPreview> trialRepaymentPlan(String userId, String productId, String amount, String term) {
//        final String url = String.valueOf(xyqbUrl + "/ex/ka/quota/preview/plans");
//        final Map<String, String> param = new HashMap<>(8);
//        param.put("userId", userId);
//        param.put("amount", amount);
//        // term=1 查第一期，term=9 查1-9期
//        param.put("term", term);
//        param.put("productId", productId);
//
//        final String result = httpService.get(url, param);
//        final Type type = new TypeToken<JsonResultGenericData<List<QuotaRepaymentPreview>>>() {}.getType();
//        final Optional<JsonResultGenericData<List<QuotaRepaymentPreview>>> jsonResultOptional = JsonUtil.fromGsonByParamType(result, type);
//        if (jsonResultOptional.isPresent() && jsonResultOptional.get().isSuccess()) {
//            return jsonResultOptional.get().getData();
//        } else {
//            LOGGER.error("[queryQueryQuotaPreview_{}][queryQueryQuotaPreview_fail]预览还款计划失败,userId={},productId={},amount={},term={},result={}", userId, amount, term, result);
//            return null;
//        }
//    }
//

}
