package cn.quantgroup.cashloanflowboss.spi.clf.service;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "CLFServiceCenter", url = "${qapi.https}", fallback = CLFCenter.Fallback.class)
public interface CLFCenter {

  @PostMapping(value = "/test//loanMq/batch", consumes = "application/x-www-form-urlencoded")
  public void loanMq(@RequestParam("json") String loanMq);

  @Component
  class Fallback implements CLFCenter {

    @Override
    public void loanMq(String loanMq) {
      return ;
    }
  }
}
