package cn.quantgroup.cashloanflowboss.api.log.controller;

import cn.quantgroup.cashloanflowboss.api.log.model.LoginFormModel;
import cn.quantgroup.cashloanflowboss.api.log.service.LogService;
import cn.quantgroup.cashloanflowboss.component.security.Power;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * Created by WeiWei on 2019/7/22.
 */
@RestController
public class LogController {

    @Autowired
    private LogService logService;

    /**
     * 登入
     *
     * @param loginFormModel
     * @return
     */
    @PostMapping("/login")
    public Result<Boolean> login(@RequestBody @Valid LoginFormModel loginFormModel) {
        return new Result<>(ApplicationStatus.SUCCESS, this.logService.login(loginFormModel.getUsername(), loginFormModel.getPassword()));
    }

    /**
     * 登出
     *
     * @return
     */
    @Security(authorityId = "Log.logout", power = Power.CREATE)
    @DeleteMapping("/logout")
    public Result<Boolean> logout() {
        return new Result<>(ApplicationStatus.SUCCESS, this.logService.logout());
    }

}
