package cn.quantgroup.cashloanflowboss.spi.mo_clotho.client;

import cn.quantgroup.cashloanflowboss.spi.xyqb.client.XYQBCenter;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author Wang Xiangwei
 * @version 2020/5/26
 */
@Component
@FeignClient(name = "MoClothoCenter", url = "${mo.clotho.http}", fallback = MoClothoCenter.Fallback.class)
public interface MoClothoCenter {



    @PostMapping(value = "/middle_office/pay/notify", consumes = "application/x-www-form-urlencoded")
    String pushLendingResult(@RequestParam Map parameter);


    @Component
    class Fallback implements MoClothoCenter{
        @Override
        public String pushLendingResult(Map parameter) {
            return null;
        }
    }

}
