package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FinanceProduct;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.IFinanceProductRepository;
import cn.quantgroup.cashloanflowboss.utils.GetBiNoAndFinanceProducts;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sun.rmi.runtime.Log;

import java.util.*;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class CreditGrantingServiceImpl implements CreditGrantingService{

    @Autowired
    private ApplyLoanService applyLoanService;

    @Autowired
    private PhoneInfoService phoneInfoService;

    @Autowired
    private OneClickDataRespository oneClickDataRespository;

    @Autowired
    private FundsAllocationplanServiceImpl fundsAllocationplanService;

    @Autowired
    private IFinanceProductRepository iFinanceProductRepository;

    public final  static String txAmount = "2000";
    public final  static String rate = "0";
    @Value("${clotho.http.net}")
    private String clothoHttp;
    @Override
    public Result authAmountAuditNotify(OneClickModel oneClickModel) throws Exception {
      String  auditResult="true";

        if(String.valueOf(TypeEnum.CREDITSUCCESS.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.LOANSUCCESS.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.LOANFAIL.getCode()).equals(oneClickModel.getType())|| String.valueOf(TypeEnum.LIQUIDATION.getCode()).equals(oneClickModel.getType()) || String.valueOf(TypeEnum.CASHWITHDRAWAL.getCode()).equals(oneClickModel.getType())){
            auditResult="true";
        }else if(String.valueOf(TypeEnum.CREDITFAIL.getCode()).equals(oneClickModel.getType())){
            auditResult="false";
        }else {
            log.info("非授信需要的状态，打印一下oneClickModel.getType()={},TypeEnum.LOANSUCCESS.getCode()={}",oneClickModel.getType(),TypeEnum.LOANSUCCESS.getCode());
        }
            return  applyCreditNotify(oneClickModel, auditResult, 0);
    }

    @Override
    public Result authAmountAuditNotifyMq(OneClickData oneClickData, QuotaCredit quotaCredit) throws Exception {
        String  auditResult="true";
        if(TypeEnum.CREDITSUCCESS.getCode() == oneClickData.getType() || TypeEnum.LOANSUCCESS.getCode() == oneClickData.getType() || TypeEnum.LOANFAIL.getCode() == oneClickData.getType() || TypeEnum.LIQUIDATION.getCode() == oneClickData.getType() || TypeEnum.CASHWITHDRAWAL.getCode() == oneClickData.getType()){
            auditResult="true";
        }else if(TypeEnum.CREDITFAIL.getCode() == oneClickData.getType()){
            auditResult="false";
        }else {
            log.info("非授信需要的状态，打印一下oneClickModel.getType()={}",oneClickData.getType());
        }
        return  applyCreditNotifyMq(oneClickData, quotaCredit, auditResult);
    }

    public Result applyCreditNotify(OneClickModel oneClickModel,String auditResult,int num) throws Exception {
        String url = clothoHttp + "/external/quota/auth_amount_audit/notify";
        Map<String, String> paras = new HashMap<String, String>();
        ArrayList listPara1 =getPublicInfo(oneClickModel);
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel", "1");
        //通过手机号获取用户信息
       XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
        log.info("打印一下xUser：{}",xUser);
        String uuid=xUser.getUuid();
        Long userId=xUser.getId();
        paras.put("uuid", uuid);
        //通过用户id获取产品信息
        log.info("打印一下userid:{},oneClickModel:{}",userId,oneClickModel);
        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecordsNotCreditStatus(userId, Long.parseLong(oneClickModel.getChannel()));

        if (Objects.isNull(quotaCredit)){

            return Result.buildFail("授信记录未查询到quotaCredit！！！，请检查数据") ;
        }else{
            log.info("打印一下quotaCredit={}",quotaCredit);
        }

        int productId= Integer.parseInt(quotaCredit.getProductId().toString().trim()) ;
        String biNo = String.valueOf(quotaCredit.getProductType());
        String quotaRecordOrderNo=quotaCredit.getOrderNo();
        //获取产品分配基础信息，默认rate都是0
        HashMap<Object, Object> getBiNoAndFinanceProduct = GetBiNoAndFinanceProducts.getBiNoAndFinanceProduct(productId, listPara1);

        paras.put("bizNo", quotaRecordOrderNo);
        paras.put("bizType", biNo);
        paras.put("auditResult", auditResult);
        paras.put("amount", oneClickModel.getAmount());
        paras.put("deadLine", "1607746332000");
        paras.put("extData", "null");
        paras.put("otherInformation", "");
        paras.put("financeProducts", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());


        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        // 通过手机号和渠道code获取token
        String getToken=phoneInfoService.getToken(oneClickModel.getPhone(), oneClickModel.getChannel());
        header.put("x-auth-token", getToken);

        log.info("获取paras={},获取header={}",paras,header);
//        QuotaCredit quotaCredit1=phoneInfoService.selectUserAuditRecords(userId,  Long.parseLong(oneClickModel.getChannel()));
//        if (Objects.isNull(quotaCredit1)){
////            quotaCredit1=quotaCredit(userId, oneClickModel.getChannel().toString().trim(),0);
////            if(Objects.isNull(quotaCredit1)){
////                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
////
////            }
//            num++;
//            if(num <=3) {
//                applyCreditNotify(oneClickModel, auditResult, num);
//            }else {
//                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
//            }
//        }else{
//            log.info("打印一下quotaCredit1={}",quotaCredit1);
//        }
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        String statusCode=result.get("statusCode").toString().trim();
        String context=result.get("context").toString().trim();

        if(ResposeResultEnum.STATUSCODE.getDesc().equals(statusCode) && ResposeResultEnum.CONTEXT.getDesc().equals(context)){
             //从数据库中获取当前的订单
            log.info("userId={},CreditStatusEnum={},LoanStatusEnum={},channel={}", userId, CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode(),oneClickModel.getChannel());
            OneClickData oneClickData=oneClickDataRespository.findByUserIdAndCreditStatusAndLoanStatusAndChannelCode(userId.toString().trim(), CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode(), oneClickModel.getChannel().toString().trim());

            log.info("获取的实体oneClickData={}",oneClickData);
            //把授信请求通知的数据存放到表one_click_data中
           int update= oneClickDataRespository.updateById(quotaRecordOrderNo.toString().trim(), quotaRecordOrderNo.toString().trim(), String.valueOf(productId).toString().trim(), getToken.toString().trim(),quotaCredit.getProductType(), oneClickData.getId());
            // 跑一遍计划
            boolean fundplan=fundsAllocationplanService.fundPlannedDistribution(oneClickData.getFundCorpId());
            if(fundplan){
                log.info("自己分配计划ok",oneClickData);
            }else{
                log.info("自己分配计划失败：{}",oneClickData);
            }
           if (update>0){
               log.info("修改成功update={}",update);
           }else{
               log.info("修改失败 !!!!!");
           }
            return new Result(ApplicationStatus.SUCCESS,new OneClickMsgResult(CreditStatusEnum.DEFAULT.getDesc()),"风控授信回调通知成功");
        }else{
            num++;
            log.info("打印循环次数num:{}",num);
            int numsum=3;
            if(num <=numsum) {
                applyCreditNotify(oneClickModel, auditResult, num);
            }else {
                return Result.buildFail("quotaCredit授信记录状态非creditStatus=1！！！，请检查数据") ;
            }
            return Result.buildFail("风控授信回调通知成功失败！！！，请检查数据") ;

        }

    }


    public QuotaCredit quotaCredit(Long userId,Long channel,int num) throws InterruptedException {
        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(userId,channel);
        int numsum=5;
        if(num<=numsum && Objects.isNull(quotaCredit)){
            num++;
            log.info("打印一下num={}",num);
            quotaCredit(userId, channel, num);
        } else{
            log.info("打印一下最终的quotaCredit={}", quotaCredit);
        }
        return quotaCredit;
    }

    public Result applyCreditNotifyMq(OneClickData oneClickData, QuotaCredit quotaCredit,String auditResult) throws Exception {
        log.info("打印quotaCredit={}",quotaCredit);
        if (Objects.isNull(quotaCredit)){
            return Result.buildFail("授信记录未查询到quotaCredit！！！，请检查数据") ;
        }
        //通过手机号获取用户信息
        XUser xUser=phoneInfoService.selectUserID(oneClickData.getPhone());
        log.info("打印一下xUser：{}",xUser);
        String uuid=xUser.getUuid();
        Long userId=xUser.getId();
        log.info("打印一下userid={},oneClickModel={}", userId, oneClickData);    //通过用户id获取产品信息
        int productId= Integer.parseInt(quotaCredit.getProductId().toString().trim());
        String biNo = String.valueOf(quotaCredit.getProductType());
        String quotaRecordOrderNo=quotaCredit.getOrderNo();
        String getToken=phoneInfoService.getToken(oneClickData.getPhone(), oneClickData.getChannelCode());      // 通过手机号和渠道code获取token
       log.info("打印当前的oneClickData={},auditResult={},quotaRecordOrderNo={},uuid={}, biNo={}, productId={},getToken={}", oneClickData, auditResult, quotaRecordOrderNo, uuid, biNo, productId, getToken);
        JSONObject result= getCreditNotifyResult(oneClickData,quotaCredit,auditResult,quotaRecordOrderNo,uuid, biNo, productId,getToken);
        log.info("打印一下查看当前的授信状态={}", result);
        String statusCode=result.get("statusCode").toString().trim();
        String statusCodeCompare="200";
        String context=result.get("context").toString().trim();
        String contextCompare="success";
        if(statusCodeCompare.equals(statusCode) && contextCompare.equals(context)) {

            //把授信请求通知的数据存放到表one_click_data中
            int update= oneClickDataRespository.updateById(quotaRecordOrderNo.toString().trim(), quotaRecordOrderNo.toString().trim(), String.valueOf(productId).toString().trim(), getToken.toString().trim(),quotaCredit.getProductType(), oneClickData.getId());
            // 修改授信状态授信成功CreditStatusEnum.CREDIT_SUCC
            if(auditResult.equals(ResposeResultEnum.CREDIT_SUCC.getDesc())){
                oneClickDataRespository.updateCreditStatusById(CreditStatusEnum.CREDIT_SUCC.getCode(), oneClickData.getId());

            }else{
                oneClickDataRespository.updateCreditStatusById(CreditStatusEnum.CREDIT_FAIL.getCode(), oneClickData.getId());

            }
            // 跑一遍计划
            boolean fundplan=fundsAllocationplanService.fundPlannedDistribution(oneClickData.getFundCorpId());
            if(fundplan){
                log.info("自己分配计划ok",oneClickData);

            }else{
                log.info("自己分配计划失败：{}",oneClickData);
            }
            if (update>0){
                log.info("修改成功update={}",update);
            }else{
                log.info("修改失败 !!!!!");
            }
            return new Result(ApplicationStatus.SUCCESS,new OneClickMsgResult(CreditStatusEnum.DEFAULT.getDesc()),"风控授信回调通知成功");
        }else{
            return Result.buildFail("风控授信回调通知成功失败！！！，请检查数据") ;
        }
    }


    public JSONObject getCreditNotifyResult(OneClickData oneClickData,QuotaCredit quotaCredit,String auditResult,String quotaRecordOrderNo,String uuid,String biNo,int productId,String getToken){
        String url = clothoHttp + "/external/quota/auth_amount_audit/notify";
        Map<String, String> paras = new HashMap<String, String>();
        ArrayList listPara1 =getPublicInfoMq(oneClickData,quotaCredit);
        log.info("打印listPara1={}",listPara1);
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel", "1");
        paras.put("uuid", uuid);
        //获取产品分配基础信息，默认rate都是0
        HashMap<Object, Object> getBiNoAndFinanceProduct = GetBiNoAndFinanceProducts.getBiNoAndFinanceProduct(productId, listPara1);

        log.info("打印getBiNoAndFinanceProduct={}", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());

        paras.put("bizNo", quotaRecordOrderNo);
        paras.put("bizType", biNo);
        log.info("打印一下auditResult={}",auditResult);
//        paras.put("auditResult",auditResult);
        paras.put("auditResult","true");
        paras.put("amount", oneClickData.getAmount().toString().trim());
        paras.put("deadLine", "1607746332000");
        paras.put("extData", "null");
        paras.put("otherInformation", "");
        paras.put("financeProducts", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");

        header.put("x-auth-token", getToken);

        log.info("获取paras={},获取header={}",paras,header);

        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        return  result;
    }

    public ArrayList getPublicInfo(OneClickModel oneClickModel){
        String fundProductId="";

        List<FinanceProduct> financeProducts= iFinanceProductRepository.findByFundCorpId(Long.getLong(oneClickModel.getFundID()));
       if(financeProducts.size()>0){
           fundProductId=financeProducts.get(0).getFundCorpId().toString().trim();
       }
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, oneClickModel.getAmount());
        listPara1.add(1, oneClickModel.getTermNo());
        listPara1.add(2, oneClickModel.getFundID());
        listPara1.add(3, rate);
        listPara1.add(4, txAmount);
        listPara1.add(5, fundProductId);
        return listPara1;

    }

    public ArrayList getPublicInfoMq(OneClickData oneClickData,QuotaCredit quotaCredit){
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, oneClickData.getAmount().toString().trim());
        listPara1.add(1, oneClickData.getTermNo());
        listPara1.add(2, oneClickData.getFundCorpId());
        listPara1.add(3, rate);
        listPara1.add(4, txAmount);
        String fundProductId="1013";
        List<FinanceProduct> getFinanceProduct=phoneInfoService.getFinanceProduct(quotaCredit.getProductId());
        if(getFinanceProduct.size()>0){
            fundProductId=String.valueOf(getFinanceProduct.get(0).getId());
        }
        listPara1.add(5, fundProductId);
        return listPara1;

    }
}
