package cn.quantgroup.cashloanflowboss.api.order.model;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 还款状态
 *
 * 还款状态，0 ("未还款")、2 ("已逾期")、3 ("已还款")
 *
 * @author lupeng
 * 2020/7/10
 */
public enum RepayStatusEnum {

    NO_REPAYMENT("0", "未还款"),
    OVERDUE("2", "已逾期"),
    OK_REPAYMENT("3", "已还款"),
    ;

    @Getter
    private String value;
    @Getter
    private String desc;

    RepayStatusEnum (String value, String desc) {
        this.desc = desc;
        this.value = value;
    }

    public static RepayStatusEnum getByValue(String value) {
        if (StringUtils.isNotBlank(value)) {
            for (RepayStatusEnum statusEnum : RepayStatusEnum.values()) {
                if (statusEnum.value.equals(value)) {
                    return statusEnum;
                }
            }
        }
        return null;
    }
}
