package cn.quantgroup.cashloanflowboss.spi.xyqb.client;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Component
@FeignClient(name = "XYQBCenter", url = "${api.https}", fallback = XYQBCenter.Fallback.class)
public interface XYQBCenter {

    @PostMapping(value = "/ex/paycenter/pay_notify", consumes = "application/x-www-form-urlencoded")
    String pushLendingResult(@RequestParam Map parameter);

    @Component
    class Fallback implements XYQBCenter {

        @Override
        public String pushLendingResult(Map parameter) {
            return null;
        }

    }

}
