package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import cn.quantgroup.cashloanflowboss.spi.xyqb.model.FundingCorpProgress;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * Created by Miraculous on 16/4/11.
 */
@Entity
@Getter
@Setter
@ToString
@Table(name = "waiting_funding_corp_operate_people")
public class WaitingFundingCorpOperatePeople implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long id;

    @Column (name = "loan_application_history_id")
    private Long loanApplicationHistoryId;

    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "fund_amount")
    private BigDecimal fundAmount;

    @Column(name = "funding_corp_progress")
    private FundingCorpProgress fundingCorpProgress = FundingCorpProgress.WAITING_FUNDING_CORP_REVIEW;

    @Column(name = "is_enable")
    private Boolean isEnable;

    @Column(name = "funding_corp_id")
    private Long fundingCorpId;

    @Column(name = "corp_loan_id")
    private String corpLoanId;

    @Column(name = "request_id")
    private String requestId;

    @Column(name = "created_at")
    private Timestamp createdAt;


    public enum FundStatus{
        SUCC("SUCC","放款成功"),
        FAIL("FAIL","放款失败"),
        HANDING("HANDING","处理中"),
        DEPOSITORY_SUCC("DEPOSITORY_SUCC","存管提现成功"),
        DEPOSITORY_FAIL("DEPOSITORY_FAIL","存管提现失败"),
        DEPOSITORY_HANDING("DEPOSITORY_HANDING","存管提现中");
        private String status;
        private String desc;

        FundStatus(String status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public String getStatus() {
            return status;
        }

        public String getDesc() {
            return desc;
        }
    }

}
