package cn.quantgroup.cashloanflowboss.spi.clf.service;

import cn.quantgroup.cashloanflowboss.api.order.model.OrderBaseModel;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.*;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * function:
 * date: 2019/9/3
 *
 * @author: suntao
 */
@Service
public class CLFCenterService {


    @Autowired
    private CallbackFailRecordRepository callbackFailRecordRepository;
    @Autowired
    private CallbackRecordRepository callbackRecordRepository;
    @Autowired
    private ClfOrderMappingRepository orderMappingRepository;
    @Autowired
    private ApplyRequestHistoryRepository applyRequestHistoryRepository;
    @Autowired
    private WithdrawRecordRepository withdrawRecordRepository;




    public List<CallbackFailRecord> findCallbackFailRecordByApplyNo(String applyNo) {
        return callbackFailRecordRepository.findByApplyNo(applyNo);
    }

    public List<CallbackRecord> findCallbackRecordByApplyNo(String applyNo) {
        return callbackRecordRepository.findByApplyNo(applyNo);
    }

    public ClfOrderMapping findOrderMappingByChannelOrderNo(String channelOrderNumber) {
        return orderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
    }

    public List<WithdrawRecord> findWithdrawRecordList(String channelOrderNumber, Long channelId) {
        return withdrawRecordRepository.findByChannelOrderNoAndChannelId(channelOrderNumber, channelId);
    }

    public List<ApplyRequestHistory> findApplyRequestHistoryBySpecification(OrderBaseModel orderBaseModel) {
        List<ApplyRequestHistory> all = applyRequestHistoryRepository.findAll(((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(orderBaseModel.getChannelId())) {
                predicates.add(criteriaBuilder.equal(root.get("channelId"), orderBaseModel.getChannelId().longValue()));
            }
            if (StringUtils.isNotEmpty(orderBaseModel.getChannelOrderNumber())) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), orderBaseModel.getChannelOrderNumber()));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();
        }));
        return all;
    }
}
