package cn.quantgroup.cashloanflowboss.api.login.service;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.service.UserServiceImpl;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Slf4j
@Service
public class LogService {

    @Autowired
    private UserServiceImpl userService;

    @Autowired
    private HttpServletRequest request;

    /**
     * 登入
     *
     * @param username 用户名
     * @param password 密码（明文）
     * @return
     */
    public String login(String username, String password) {

        User user = this.userService.getUser(username);

        // 检查用户是否有效
        Assert.isNull(user, ApplicationStatus.INVALID_USER);

        // 检查用户是否被禁用
        Assert.isTrue(UserStatus.DISABLED.equals(user.getStatus()), ApplicationStatus.DISABLED_USER);

        // 检查密码是否正确
        Assert.isFalse(user.getPassword().equalsIgnoreCase(MD5Tools.md5(password)), ApplicationStatus.USERNAME_OR_PASSWORD_ERROR);

        // 创建Session
        HttpSession session = this.request.getSession(true);

        // 设置用户主要信息
        Principal principal = new Principal();
        principal.setUserId(user.getId());
        principal.setChannelId(user.getChannelId());
        principal.setRank(user.getRank());
        principal.setRoles(user.getRoles());

        session.setAttribute(ApplicationDictionary.PRINCIPAL, JSONTools.serialize(principal));

        return session.getId();

    }

    /**
     * 登出
     *
     * @return
     */
    public boolean logout() {

        this.request.getSession().removeAttribute(ApplicationDictionary.PRINCIPAL);

        return true;

    }

}
