package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickModel;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickSelectModel;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.OneClickDataOperateService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.GetEncryptContentAndMd5;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by shang on 2019/12/9.
 */
@Slf4j
@Service
public class OneClickDataOperateServiceImpl implements OneClickDataOperateService {

    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private ApplyLoanService applyLoanService;
    @Autowired
    private CreditGrantingService creditGrantingService;

    @Override
    public Result OnekeyApply(OneClickModel oneClickModel) {
        return applyLoanService.applyLoan(oneClickModel);
    }

    @Override
    public Result OneKeyCashWithdrawal(OneClickModel oneClickModel)throws Exception {

        return OneKeyCreditSuccessOrFail(oneClickModel);
    }

    @Override
    public Result OneKeyCreditSuccessOrFail(OneClickModel oneClickModel) throws Exception {
        return applyLoanService.applyLoan(oneClickModel);

    }

    public Result OneKeyCreditSuccessOrFailOld(OneClickModel oneClickModel) throws Exception {
        Result creditResult=applyLoanService.applyLoan(oneClickModel);
        if(creditResult.getCode()== ApplicationStatus.SUCCESS.getCode()){
            log.info("申请成功后，进入风控回调环境={}",creditResult);
        return   creditGrantingService.authAmountAuditNotify(oneClickModel);

        }else {
            log.info("当前进行进件申请失败oneClickModel={},creditResult={}",oneClickModel,creditResult);
            return creditResult;
        }

    }

    @Override
    public Result OneKeyLoanSuccessOrFail(OneClickModel oneClickModel)throws Exception  {
        return OneKeyCreditSuccessOrFail(oneClickModel);
    }

    public Page<OneClickSelectModel>  findOneClickSelectModelByCriteriaQueryPage(OneClickSelectModel oneClickSelectModel){
        Page<OneClickData> oneClickDatas=  findOneClickDataByCriteriaQueryPage(oneClickSelectModel);
        log.info("打印一下oneClickDatas：{}",oneClickDatas);
        Page<OneClickSelectModel> oneClickSelectModels=oneClickDatas.map(it -> {
            OneClickSelectModel oneClickSelectModelDemo=new OneClickSelectModel();
            oneClickSelectModelDemo.setPhone(it.getPhone());
            oneClickSelectModelDemo.setUserId(it.getUserId());
            oneClickSelectModelDemo.setLoanId(it.getLoanId());
            oneClickSelectModelDemo.setLoanStatus(String.valueOf(it.getLoanStatus()));
            oneClickSelectModelDemo.setLoanMessage(GetEncryptContentAndMd5.getLoanMessage(it.getLoanStatus()));
            oneClickSelectModelDemo.setCreditStatus(String.valueOf(it.getCreditStatus().getCode()));
            oneClickSelectModelDemo.setCreditMessage(it.getCreditStatus().getDesc());
            oneClickSelectModelDemo.setUuid(it.getUuid());
            oneClickSelectModelDemo.setQgOrderNo(it.getChannelOrderNo());
            log.info("oneClickSelectModelDemo={}",oneClickSelectModelDemo);
       return oneClickSelectModelDemo;
        });
                return oneClickSelectModels;
    }

    public Page<OneClickData> findOneClickDataByCriteriaQueryPage(OneClickSelectModel oneClickSelectModel) {
        return oneClickDataRespository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定手机号
            if (StringUtils.isNotEmpty(oneClickSelectModel.getPhone())) {

                predicates.add(criteriaBuilder.equal(root.get("phone"), oneClickSelectModel.getPhone()));
            }

            if (StringUtils.isNotEmpty(oneClickSelectModel.getUserId())) {
                predicates.add(criteriaBuilder.equal(root.get("userId"), oneClickSelectModel.getUserId()));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));
            log.info("打印一下criteriaQuery:{}", criteriaQuery.getRestriction());

            return criteriaQuery.getRestriction();

        }, new PageRequest(Integer.valueOf(oneClickSelectModel.getPageNumber()), Integer.valueOf(oneClickSelectModel.getPageSize())));
    }


}
