package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;


import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.OneClickDataOperateJobService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * Created by shang on 2019/12/12.
 */
@Slf4j
@Service
public class OneClickDataOperateJobServiceImpl implements OneClickDataOperateJobService {

    @Autowired
    private PhoneInfoService phoneInfoService;

    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CreditGrantingService creditGrantingService;

    @Override
    public void excuteCreditSuccessJob() {

    }

    @Override
    public void excuteCreditFailJob() {

    }

    @Override
    public void excuteSelectCreditStatusJob() {



        //查找请求类型：2授信成功、4放款成功、5放款失败、6清算的单，并且当前的授信状态是0授信中

        List<OneClickData>  oneClickDataList=oneClickDataRespository.findByCreditStatusAndTypeNotIn(0, 1);
        if(oneClickDataList.size()>0 || oneClickDataList !=null) {

            for (OneClickData oneClickData : oneClickDataList) {
                // 当前授信中的单在apply_quota 查看状态是apply_status=1 时间倒序,进行授信请求操作
                log.info("打印一下oneClickData.getUserId()={},oneClickData.getChannelCode()={}",oneClickData.getUserId(),oneClickData.getChannelCode());
                QuotaCredit quotaCredit1 = phoneInfoService.selectUserAuditRecords(Long.parseLong(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
                if (Objects.isNull(quotaCredit1)) {
                    log.info("不符合授信审核申请的条件");
                } else {
                    //如何条件的单进行授信申请请求
                    log.info("符合授信审核申请的条件oneClickData={},quotaCredit1={}", oneClickData, quotaCredit1);
                    try {
                        creditGrantingService.authAmountAuditNotifyMq(oneClickData, quotaCredit1);

                    } catch (Exception e) {
                        log.info("进入异常e={}", e.getMessage());
                    }
                }
            }
        }else{
            log.info("oneClickDataList为空={}",oneClickDataList);
        }


    }

    @Override
    public void excuteFundSucessJob() {

    }

    @Override
    public void excuteFundFailJob() {

    }

    @Override
    public void excuteSelectFundStatusJob() {

    }
}
