package cn.quantgroup.cashloanflowboss.api.oneclickdata.service;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.RepaymentPlan;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by shang on 2019/12/5.
 */
public interface RepaymentPlatService {
    /**
     * 是否有未还款计划
     **/
    RepaymentPlan whetherHaveRepayment0rdersList(String loanId);
    /**
     * 获取还款计划表
     **/
    void getRepayment0rdersList(String loanID,String token);
    /**
     * 支付中心token获取
     **/
    String getRepaymentToken(String loanID,String token);
    /**
     * 获取卡信息
     *
     * */
    JSONObject getCardListInfo(String repaymentToken);

    /**
     * 获取金额信息
     *
     * * */
    void getPayMoneyInfo(String repaymentToken);

    /**
     * 支付确认页面
     * */
    void paymentConfirmation(String cardBindInfoId1,String cardId);

    /**
     * 银行卡认证信息
     * */
    void bankCardAuthenticationInformation(String repaymentToken);

    /**
     * 发送验证码
     * */
    void sendSMS(String repaymentToken);

    /**
     * 确认支付
     * */
    void confirmPayment(String repaymentToken);

    /**
     * 绑卡操作
     * */
    void bingCard(String repaymentToken,JSONObject info);

    /**
     * 绑卡操作-获取短信验证码
     * */
    void bingCardSms(String repaymentToken,JSONObject info);

    /**
     * 绑卡操作-确认绑卡
     * */
    void bingCardSmsConfirm(String repaymentToken,JSONObject info);


}
