package cn.quantgroup.cashloanflowboss.spi.jolyne;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "JolyneServiceCenter", url = "http://192.168.4.156:9001/executeSQL/{{NAMESPACE}}", fallback = JolyneCenter.Fallback.class)
public interface JolyneCenter {


  @PostMapping(value = "/xyqb", consumes = "application/json")
  String sqlXyqb(@RequestParam("json") String cancelData);

  @Component
  class Fallback implements JolyneCenter {

    @Override
    public String sqlXyqb(String cancelData) {
      return null;
    }
  }
}
