package cn.quantgroup.cashloanflowboss.api.user.service;

import cn.quantgroup.cashloanflowboss.api.role.entity.boss.Permission;
import cn.quantgroup.cashloanflowboss.api.role.entity.boss.Role;
import cn.quantgroup.cashloanflowboss.api.role.service.RoleService;
import cn.quantgroup.cashloanflowboss.api.user.entity.boss.User;
import cn.quantgroup.cashloanflowboss.api.user.model.RoleInfo;
import cn.quantgroup.cashloanflowboss.api.user.model.UserInfo;
import cn.quantgroup.cashloanflowboss.api.user.model.UserSessionInfo;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpSession;
import java.util.Arrays;

@Slf4j
@Service
public class UserSessionService {

    @Autowired
    private RoleService roleService;

    public void setUserSessionInfo(User user) {

        //set user,role,channel or permission info
        Role role = roleService.findRoleByUserId(user.getId());
        String roleName = null, userName = user.getUsername();
        Long roleId = null, userId = user.getId();
        if (null != role) {
            roleName = role.getName();
            roleId = role.getId();
        }

        UserSessionInfo userSessionInfo = UserSessionInfo.builder()
                .roleInfo(RoleInfo.builder().roleId(roleId).roleName(roleName).build())
                .userInfo(UserInfo.builder().userId(userId).userName(userName).build())
                .build();

        HttpSession session = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest().getSession();
        session.setAttribute(ApplicationDictionary.USER_KEY, JSONTools.serialize(userSessionInfo));

        //todo permission后续放入UserSessionInfo结构中吧
        Permission permission = new Permission();
        permission.setId("Log.logout");
        permission.setAuthorities(Arrays.asList(Authority.READ));
        session.setAttribute(ApplicationDictionary.SECURITY_KEY, JSONTools.serialize(Arrays.asList(permission)));

    }


    public UserSessionInfo findUserSessionInfo() {
        HttpSession session = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest().getSession();
        Assert.isNull(session.getAttribute(ApplicationDictionary.USER_KEY), ApplicationStatus.INVALID_USER);
        UserSessionInfo userSessionInfo = JSONTools.deserialize(String.valueOf(session.getAttribute(ApplicationDictionary.USER_KEY)), new TypeReference<UserSessionInfo>() {
        });
        return userSessionInfo;
    }


}
