package cn.quantgroup.cashloanflowboss.api.channel.service;
import java.util.Date;

import cn.quantgroup.cashloanflowboss.api.channel.entity.boss.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelListModel;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ChannelConfiguration;
import cn.quantgroup.cashloanflowboss.api.channel.repository.boss.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ChannelConfigurationRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.user.model.Pagination;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */

@Service
public class ChannelConfService {

    @Autowired
    private ChannelConfRepository channelConfRepository;

    @Autowired
    private ChannelConfigurationRepository clfChannelConfigurationRepository;



    public Page<ChannelListModel> getChannelInfo(Integer pageNumber, Integer pageSize, Integer channelId) {

        Page<ChannelConfiguration> page = this.clfChannelConfigurationRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("channelId"), channelId));
            }

            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        Page<ChannelListModel> channelListModelPage = page.map(it -> {
            ChannelListModel channelListModel = new ChannelListModel();
            channelListModel.setChannelId(it.getRegisteredFrom());
            channelListModel.setChannelName(it.getChannelName());
            channelListModel.setChannelCode(it.getChannelCode());
            channelListModel.setBizType(1);
            channelListModel.setCreatedAt(it.getCreatedAt());
            return channelListModel;
        });

        return channelListModelPage;
    }


    public Result getChannelConf(Integer channelId) {
        ChannelConf channelConf = channelConfRepository.getByChannelId(channelId);
        return Result.buildSuccess(ChannelConfUtil.channelConfConvertVOModel(channelConf), "success");
    }


}
