package cn.quantgroup.cashloanflowboss.api.oneclickdata.model;

import lombok.Getter;

/**
 * 放款状态
 * 放款状态：50已申请提现、20等待马上金融放款、21已发送给马上金融, 等待放款、15查看还款计划、16借款完成、28放开失败
 * @author shang
 */
@Getter
public enum LoanStatusEnum {

    DEFAULT(0, "未付款，未核销"),
    LOAN_UNCONFIRM(1, "资金方放款状态未知（未核销）"),
    LOAN_UNCONFIRMTWO(2, "dsds）"),
    LOAN_UNCONFIRMTHRE(3, "资金方放款状态未知33（未核销）"),
    CHECK_REPAYMENT_PLAN(15,"查看还款计划"),//15
    LOAN_COMPLETE(16,"借款完成"),//16
    LOAN_FAIL(28, "放款失败（等待退款）"),
    APPLY_WITHDRAWDEPOSIT(50, "已申请提现"),
    WAIT_JRLOAN(20, "等待马上金融放款"),
    TO_JRWAITLOAN(21, "已发送给马上金融, 等待放款"),
    BIND_FAIL(31,"提现绑卡失败"),
    SECONDARYRISKCONTROLFAILURE(32,"二次风控失败"),
    NOTHAVECONTRACT(33,"修改合同失败"),
    BIND_SUCC_NOTHAVEFUNDORDER(34,"提现成功，未查询到放款单"),
    DIRECT_INVESTMENT_FAILURE(34,"直投打款失败"),
    LOAN_REQUEST_FAILED (35,"放款请求失败"),
    DIRECT_INVESTMENT_SUCCESS_STATUSNOTRIGHT (36,"直投打款成功，但状态不对");
    private int code;

    private String desc;

    LoanStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
