package cn.quantgroup.cashloanflowboss.api.oneclickdata.service;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import com.alibaba.fastjson.JSONObject;

import java.math.BigDecimal;
import java.util.Map;

/**
 * Created by shang on 2019/12/3.
 */
public interface LoanOperationService {
    /*
    * 放款通知请求
    * */
    Result applyLoanNotify(OneClickData oneClickData);

    /**
     * 查询loanID
     */
    LoanApplicationHistory selectLoanId(Long userId,Integer businessType);


    /**
     * 二次风控
     * */
    JSONObject orderAuditNotify(OneClickData oneClickData);

    /**
     * 修改合同状态
     * */
    boolean updatContractStatus(OneClickData oneClickData);

    /**
     * 放款结果通知
     * */
    JSONObject payNotify(OneClickData oneClickData,String payStatus);

    /**
     * 查询放款记录
     *
     * @param fundId
     * @return
     */
   Map queryLendingRecordCount(Long fundId);


    Long queryLendingRecordSumCount(Long fundId);

    BigDecimal queryLendingRecordAmountMountSumCount(Long fundId);

    /**
     * 修改待放款用户创建时间
     * */
   int updatWaitingFundingCorpOperatePeopleCreaterTime(Long fundID);

    /**
     * 直投打款
     * */
    JSONObject fundsPlanLoanApply(OneClickData oneClickData,String payStatus);


}
