package cn.quantgroup.cashloanflowboss.core.configuration.security;

import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.service.UserService;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Component
public class CustomAuthenticationProvider implements AuthenticationProvider {

    @Autowired
    private UserService userService;

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {

        User user = this.userService.getUser(authentication.getName());

        // 检查用户是否存在
        Assert.isNull(user, ApplicationStatus.INVALID_USER);

        // 检查用户是否被禁用
        Assert.isTrue(UserStatus.DISABLED.equals(user.getStatus()), ApplicationStatus.DISABLED_USER);

        // 检查用户密码是否一致
        Assert.isFalse(user.getPassword().equalsIgnoreCase(MD5Tools.md5(authentication.getCredentials().toString())), ApplicationStatus.USERNAME_OR_PASSWORD_ERROR);

        Collection<? extends GrantedAuthority> authorities = authentication.getAuthorities();

        return new UsernamePasswordAuthenticationToken(user, authentication.getCredentials(), authorities);

    }

}
