package cn.quantgroup.cashloanflowboss.api.log.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Objects;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Slf4j
@Service
public class LogService {

    @Autowired
    private AuthenticationManager authenticationManager;

    @Autowired
    private HttpServletRequest request;

    /**
     * 登入
     *
     * @param username 用户名
     * @param password 密码（明文）
     * @return
     */
    public boolean login(String username, String password) {

        SecurityContext securityContext = SecurityContextHolder.getContext();
        securityContext.setAuthentication(this.authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(username, password)));

        HttpSession session = this.request.getSession(true);
        session.setAttribute(HttpSessionSecurityContextRepository.SPRING_SECURITY_CONTEXT_KEY, securityContext);

        return securityContext.getAuthentication().isAuthenticated();

    }

    /**
     * 登出
     *
     * @return
     */
    public boolean logout() {

        new SecurityContextLogoutHandler().logout(this.request, null, SecurityContextHolder.getContext().getAuthentication());

        return Objects.isNull(SecurityContextHolder.getContext().getAuthentication());

    }

}
