package cn.quantgroup.cashloanflowboss.spi.xyqb.client;

import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Component
@FeignClient(name = "XYQBCenter", url = "${api.https}", fallback = XYQBCenter.Fallback.class)
public interface XYQBCenter {

    @PostMapping(value = "/ex/paycenter/pay_notify", consumes = "application/x-www-form-urlencoded")
    String pushLendingResult(@RequestParam Map parameter);

    @PostMapping(value = "/ex/ka/order/status", consumes = "application/x-www-form-urlencoded")
    ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getOrderStatus(@RequestParam Map paramMap);

    @PostMapping(value = "/ex/ka/order/status/history", consumes = "application/x-www-form-urlencoded")
    ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(@RequestParam Map paramMap);

    @Component
    class Fallback implements XYQBCenter {

        @Override
        public String pushLendingResult(Map parameter) {
            return null;
        }

        @Override
        public ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getOrderStatus(Map orderNo) {
            return null;
        }

        @Override
        public ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(Map paramMap) {
            return null;
        }


    }

}
