package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundLending;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Repository
public interface FundLendingRepository extends CrudRepository<FundLending, Integer> {

    /**
     * 更新资方待放款创建时间
     *
     * @param loanId
     * @param time
     * @return
     */
    @Query("update FundLending set createTime = :createTime where loanId = :loanId")
    boolean updateCreateTime(@Param("loanId") Long loanId, @Param("createTime") Date time);

    /**
     * 查询待放款记录
     *
     * @param fundId
     * @param progress
     * @return
     */
    @Query("select sum(amount) as totalAmount ,count(fundId) as totalCount from FundLending where progress = :progress and fundId = :fundId")
    Map queryLendingRecordCount(Integer fundId, Integer progress);

}