package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CashWithdrawalService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.LoanOperationService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.utils.*;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/18.
 */
@Slf4j
@Service
public class CashWithdrawalServiceImpl implements CashWithdrawalService{
    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CLFCenterServiceImpl clfCenterService;
    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private LoanOperationService loanOperationService;

    private ClfChannelConfiguration clfChannelConfiguration;
    private  String md5Keywy = "qEAxMJBv";
    private  String aesKeywy = "sxD8KO79EDK0N0AJ";


    /**
    *申请提现请求
    * */
    @Override
    public Result applyLoan(OneClickData oneClickData) {
        JSONObject result;
        //通过用户id获取产品信息
//        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(Long.valueOf(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
//        log.info("打印quotaCredit={}",quotaCredit);
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickData.getChannelCode().trim()));
        log.info("oneClickData={}",oneClickData);
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();
        result= applyLoan(oneClickData, md5Keywy, aesKeywy);
//        if(oneClickData.getChannelCode().trim().equals(ChannelEnum.ZHANGHZONG.getCode())){
//            result= applyZhangZhongLoan(oneClickData, md5Keywy, aesKeywy);
//
//        }else if(oneClickData.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
//            result= null;
//        }else if(oneClickData.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
//            result= null;
//        }else if(oneClickData.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
//            result= null;
//        }else if(oneClickData.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
//            result= null;
//        }else{
//            result= null;
//        }
          String context=result.get("context").toString().trim();
        if(!StringUtils.isBlank(context)){
            String getDecryption = AESUtil.decryptAfterBase64Decode(context, aesKeywy);

            log.info("解密的getDecryption的结果={}" + getDecryption);

            JSONObject getDecryptionResult = (JSONObject) JSONObject.parse(getDecryption);
            log.info("打印一下getDecryptionResult={}",getDecryptionResult.get("bizData"));
            JSONObject bizData= (JSONObject) JSONObject.parse(getDecryptionResult.get("bizData").toString());
            log.info("提现结果打印bizData={}",bizData);
            String code=bizData.get("code").toString();
            String codeCompare="0";
            String businessCode=bizData.get("businessCode").toString();
            String businessCodeCompare="0000";
            String msg=bizData.get("msg").toString().trim();
            log.info("msg={}",msg);
            boolean isOk=(codeCompare.equals(code) && businessCodeCompare.equals(businessCode))|| "订单已经提现签约过".equals(msg)||("0".equals(code) && "0200".equals(businessCode));
            if(isOk){
                // 通过userid查看当前的提现记录是否生成放款loanid
                LoanApplicationHistory applicationHistory=new LoanApplicationHistory();
//            log.info("oneClickData.getUserId()={},quotaCredit.getProductType()={}",oneClickData.getUserId(),quotaCredit.getProductType());
                applicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId()), oneClickData.getBizType());
                log.info("打印获取的放款单信息applicationHistory={}",applicationHistory);
                if(Objects.isNull(applicationHistory)){
                    applicationHistory=verificationApplicationHistory(applicationHistory,Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType(),0);
                }else{
                    log.info("打印放款id,applicationHistory.getId()={}",applicationHistory.getId());
                }
                return new Result(ApplicationStatus.SUCCESS,new OneClickMsgResult(applicationHistory.getId().toString().trim(),LoanStatusEnum.APPLY_WITHDRAWDEPOSIT.getDesc(),CreditStatusEnum.CREDIT_SUCC.getDesc()));
            }else{
                return Result.buildFail(msg) ;
            }
        }else {
            return Result.buildFail("获取结果值空context={}",context) ;

        }
    }


   public LoanApplicationHistory verificationApplicationHistory(LoanApplicationHistory applicationHistory,Long userId,Integer businessType,int num){
       if(Objects.isNull(applicationHistory)){
           applicationHistory = loanOperationService.selectLoanId(userId, businessType);
           int numsum=50;
           if(num< numsum&& Objects.isNull(applicationHistory)){
               num++;
               verificationApplicationHistory(applicationHistory,userId, businessType,num);
           }else{
               log.info("打印一下最终的quotaCredit={}", applicationHistory);
           }
       }
       return applicationHistory;
   }

    public JSONObject applyLoan(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        Map<String,String> paras = new HashMap<String, String>();
        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        String channelCode="ZHANGZHONG";
        String url ="";
        if(oneClickData.getChannelCode().trim().equals(ChannelEnum.ZHANGHZONG.getCode())){
            channelCode="ZHANGZHONG";
            paras= applyZhangZhongLoan(oneClickData,bankCardNumber,bankCode,bankName);
        }else if(oneClickData.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            channelCode="SHIGUANGFQ";
            paras= applyShiGuangFenQiLoan(oneClickData, bankCardNumber, bankCode, bankName);
        }else if(oneClickData.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
            channelCode="XIAOJUMAO";
            paras= applyXiaoJMLoan(oneClickData, bankCardNumber, bankCode, bankName);

        }else if(oneClickData.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
            channelCode="GUOMEI";
            paras= applyGuoMeiLoan(oneClickData, bankCardNumber, bankCode, bankName);
        }else if(oneClickData.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
            channelCode="WEIDIAN";
            paras= applyWeiDianLoan(oneClickData, bankCardNumber, bankCode, bankName);

        }else{

        }

        url=qapiHttp+"/ex/api/v2/withdraw/"+channelCode;

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}",paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);

        return result;
    }


    /**
     * 掌众的申请提现
     * */
    public Map applyZhangZhongLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());


        return paras;
    }


    /**
     * 时光分期的申请提现
     * */
    public Map applyShiGuangFenQiLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());


        return paras;
    }


    /**
     * 小桔猫的申请提现
     * */
    public Map applyXiaoJMLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }

    /**
     * 国美的申请提现
     * */
    public Map applyGuoMeiLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }



    /**
     * 微店的申请提现
     * */
    public Map applyWeiDianLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }

    /**
   * 掌众老的申请提现
   * */
    public JSONObject applyZhangZhongLoanOld(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        String url = qapiHttp+"/ex/api/v2/withdraw/ZHANGZHONG";


        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        Map<String,String> paras = new HashMap<String, String>();

        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber",oneClickData.getPhone());

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}",paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);


        return result;
    }


    /**
     * 时光分期老的申请提现
     * */
    public JSONObject applyShiGuangFenQiLoanOld(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        String url = qapiHttp+"/ex/api/v2/withdraw/SHIGUANGFQ";


        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        Map<String,String> paras = new HashMap<String, String>();

        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber",oneClickData.getPhone());

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}",paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);


        return result;
    }

}
