package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.utils.AESUtil;
import cn.quantgroup.cashloanflowboss.utils.ChineseIDCardNumberGenerator;
import cn.quantgroup.cashloanflowboss.utils.GetEncryptContentAndMd5;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class ApplyLoanServiceImpl implements ApplyLoanService {
    private String idNo =  ChineseIDCardNumberGenerator.generate();
    private String orderNo="testOrderNo_0001";

    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CLFCenterServiceImpl clfCenterService;

    @Autowired
    private PhoneInfoService phoneInfoService;

    private OneClickMsgResult oneClickOv;
    private ClfChannelConfiguration clfChannelConfiguration;
    private  String md5Keywy = "qEAxMJBv";
    private  String aesKeywy = "sxD8KO79EDK0N0AJ";
    private Result oneClickReslut=new Result();

    @Override
    public Result applyLoan(OneClickModel oneClickModel){
        JSONObject result;
        oneClickReslut=new Result();
        oneClickOv=new OneClickMsgResult();
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickModel.getChannel().trim()));
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();
        result=apply(oneClickModel,md5Keywy,aesKeywy);
//        if(oneClickModel.getChannel().equals(ChannelEnum.ZHANGHZONG.getCode())){
//            result= zhangZhongApply(oneClickModel,md5Keywy,aesKeywy);
//        }else if(oneClickModel.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
//            result= shiGuangFenQiApply();
//        }else if(oneClickModel.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
//            result= xiaoJMApply();
//        }else if(oneClickModel.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
//            result= guoMeiApply();
//        }else if(oneClickModel.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
//            result= weiDianApply();
//        }else{
//            result= defautApply();
//        }
        String getDecryption = AESUtil.decryptAfterBase64Decode(result.get("context").toString(), aesKeywy);
        log.info("解密的getDecryption的结果={}" + getDecryption);
        JSONObject getDecryptionResult = (JSONObject) JSONObject.parse(getDecryption);
        log.info("打印一下getDecryptionResult={}",getDecryptionResult.get("bizData"));
        JSONObject bizData= (JSONObject) JSONObject.parse(getDecryptionResult.get("bizData").toString());
        log.info("bizData={}",bizData);
        String code=bizData.get("code").toString();
        String businessCode=bizData.get("businessCode").toString();
        String msg=bizData.get("msg").toString();
        log.info("msg={}",msg);
        if(code.equals(ResposeResultEnum.CODE.getDesc()) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            //申请的数据插入数据库 one_click_data
            OneClickData oneClickData=new OneClickData();
            oneClickData.setPhone(oneClickModel.getPhone());
            oneClickData.setChannel(GetEncryptContentAndMd5.getChannelName(oneClickModel.getChannel()));
            oneClickData.setChannelCode(oneClickModel.getChannel());
            oneClickData.setChannelOrderNo(orderNo);
            //通过手机号获取用户信息
            XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
            oneClickData.setUserId(xUser.getId().toString());
            oneClickData.setUuid(xUser.getUuid());

            oneClickData.setType(Integer.parseInt(oneClickModel.getType()));
            oneClickData.setCreditStatus(CreditStatusEnum.DEFAULT);
            oneClickData.setLoanStatus(LoanStatusEnum.DEFAULT.getCode());
            oneClickData.setFundCorpId(oneClickModel.getFundID());
            oneClickData.setAmount(new BigDecimal(oneClickModel.getAmount()));
            oneClickData.setTermNo(Integer.parseInt(oneClickModel.getTermNo()));
            // 把提现的数据存放到表one_click_data中
            oneClickDataRespository.save(oneClickData);
            oneClickOv.setCreditMessage(CreditStatusEnum.DEFAULT.getDesc());
            oneClickOv.setLoanMessage(LoanStatusEnum.DEFAULT.getDesc());
            oneClickReslut.setData(oneClickOv);
            oneClickReslut.setCode(ApplicationStatus.SUCCESS.getCode());
            oneClickReslut.setMessage(msg);
            return oneClickReslut;
        }else{
            oneClickReslut.setMessage(msg);
            oneClickReslut.setData(oneClickOv);
            oneClickReslut.setCode(ApplicationStatus.FAILURE.getCode());
            return oneClickReslut;
        }

    }



    public JSONObject apply(OneClickModel oneClickModel,String md5Keywy,String aesKeywy){
        JSONObject result;
        String channelCode="ZHANGZHONG";
        String orderNoStart="begin";


        //测试
//        String url = "http://qapi-arch.liangkebang.net"+"/ex/api/v2/applyLoan/ZHANGZHONG";

        orderNo=orderNoStart+"_"+oneClickModel.getPhone()+"_"+System.currentTimeMillis();
        String name = "简介";
        String channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();
        Map<String, Object> paras=new HashMap<String, Object>();
        if(oneClickModel.getChannel().equals(ChannelEnum.ZHANGHZONG.getCode())){
            channelCode="ZHANGZHONG";
            orderNoStart="ZZ";
            channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();
            paras= zhangZhongApply(oneClickModel,name,channelUserId);
        }else if(oneClickModel.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            channelCode="SHIGUANGFQ";
            orderNoStart="SGFQ";
            channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();
            paras= shiGuangFenQiApply(oneClickModel,name,channelUserId);

        }else if(oneClickModel.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
            channelCode="XIAOJUMAO";
            orderNoStart="XJM";
            channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();
            paras= xiaoJMApply(oneClickModel,name,channelUserId);

        }else if(oneClickModel.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
            channelCode="GUOMEI";
            orderNoStart="GM";
            channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();

            paras= guoMeiApply(oneClickModel,name,channelUserId);

        }else if(oneClickModel.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
            channelCode="WEIDIAN";
            orderNoStart="WD";
            channelUserId = orderNoStart+"_"+ oneClickModel.getPhone();

            paras= weiDianApply(oneClickModel,name,channelUserId);

        }else{
            paras= defautApply(oneClickModel,name,channelUserId);
        }
        String url = qapiHttp+"/ex/api/v2/applyLoan/"+channelCode;
        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content", encryptContent);
        log.info("查看结果content={}", content_map);
         result = HttpRequest.doPostReturnResponseJson(url, content_map);
        return result;
    }


    @Override
    public  Map<String, Object> zhangZhongApply(OneClickModel oneClickModel,String name,String channelUserId) {
        Map<String, Object> paras =new HashMap<String, Object>();

        paras.put("address", "湖北省恩施州利川团堡");
        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("amount","11110.00");
        para2.put("period","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put("organization", "1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, para7);
        paras.put("creditList", listPara1);
        return paras;

    }


    public JSONObject zhangZhongApplyOld(OneClickModel oneClickModel,String md5Keywy,String aesKeywy) {
        String url = qapiHttp+"/ex/api/v2/applyLoan/ZHANGZHONG";
        //测试
//        String url = "http://qapi-arch.liangkebang.net"+"/ex/api/v2/applyLoan/ZHANGZHONG";

        orderNo="ZZ_"+oneClickModel.getPhone()+"_"+System.currentTimeMillis();
        String name = "简介";
        String channelUserId = "ZZ_"+ oneClickModel.getPhone();

        Map<String, Object> paras =getParas(oneClickModel,name,channelUserId);


        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content", encryptContent);
        log.info("查看结果content={}", content_map);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);
        return result;


    }

    public  Map<String, Object> getParas ( OneClickModel oneClickModel,String name,String channelUserId){
        Map<String, Object> paras =new HashMap<String, Object>();

        paras.put("address", "湖北省恩施州利川团堡");
        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("amount","11110.00");
        para2.put("period","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put("organization", "1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, para7);
        paras.put("creditList", listPara1);
        return paras;

    }


    @Override
    public  Map<String, Object> shiGuangFenQiApply(OneClickModel oneClickModel,String name,String channelUserId) {
        Map<String, Object> paras =new HashMap<String, Object>();
        paras.put("address", "湖北省恩施州利川团堡");

        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("auditAmount","11110.00");
        para2.put("auditTerm","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put( "organization","1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0,para7);
        paras.put("creditList",listPara1);
        return paras;
    }

    @Override
    public  Map<String, Object> xiaoJMApply(OneClickModel oneClickModel,String name,String channelUserId) {
        Map<String, Object> paras =new HashMap<String, Object>();
        paras.put("address", "湖北省恩施州利川团堡");

        paras.put("applyAmount",  oneClickModel.getAmount());
        paras.put("applyTerm",  oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone",  oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("auditAmount","11110.00");
        para2.put("auditTerm","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put( "organization","1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0,para7);
        paras.put("creditList",listPara1);
        return paras;
    }

    @Override
    public  Map<String, Object> guoMeiApply(OneClickModel oneClickModel,String name,String channelUserId) {
        Map<String, Object> paras =new HashMap<String, Object>();
        paras.put("address", "湖北省恩施州利川团堡");
        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("emergencyContactNameC","联系人三");
        paras.put("emergencyContactPhoneC","13577773333");
        paras.put("emergencyContactRelationC","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("auditAmount","11110.00");
        para2.put("auditTerm","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        para4.put("idCardBaseContentA", "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" );
        para4.put("idCardBaseContentB","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");
        para4.put("livePhotoContent","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");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put( "organization","1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0,para7);
        paras.put("creditList",listPara1);
        return null;
    }

    @Override
    public  Map<String, Object> weiDianApply(OneClickModel oneClickModel,String name,String channelUserId) {
        Map<String, Object> paras =new HashMap<String, Object>();
        paras.put("address", "湖北省恩施州利川团堡");
        paras.put("applyAmount", oneClickModel.getAmount());
        paras.put("applyTerm", oneClickModel.getTermNo());

        paras.put("districtCode","123456");
        paras.put("education","MASTER");
        paras.put("email","22@qq.com");
        paras.put("emergencyContactNameA","孙打她");
        paras.put("emergencyContactNameB","斯柯达");
        paras.put("emergencyContactPhoneA","13099992222");
        paras.put("emergencyContactPhoneB","13577771111");
        paras.put("emergencyContactRelationA","FRIEND");
        paras.put("emergencyContactRelationB","CHILDREN");
        paras.put("emergencyContactNameC","联系人三");
        paras.put("emergencyContactPhoneC","13577773333");
        paras.put("emergencyContactRelationC","CHILDREN");
        paras.put("hasCar","false");
        paras.put("hasCreditCard","false");
        paras.put("hasHouse","false");
        paras.put("hasSocialSecurity","false");
        paras.put("idCardNo",idNo);
        paras.put("income","CASH");
        paras.put("incomeRange","BELOW_20000");
        paras.put("kaTest","false");
        paras.put("loanDemandPurpose", "FAMILY_DECORATION");
        paras.put("marryStatus","MARRIED");
        paras.put("occupation","EMPLOYEE");
        paras.put("orderNo",orderNo);
        paras.put("phone", oneClickModel.getPhone());
        paras.put("qq","233223222");
        Map<String,String> para2 = new HashMap<String, String>();
        para2.put("auditAmount","11110.00");
        para2.put("auditTerm","6");
        paras.put("scenarioData", para2);
        paras.put("userName",name);
        Map<String,Object> para3 = new HashMap<String, Object>();
        Map<String,Object> para4 = new HashMap<String, Object>();
        Map<String,Object> para5 = new HashMap<String, Object>();
        para4.put("name",name);
        para4.put("citizen_id",idNo);
        para4.put("valid_date_begin","2013-07-26");
        para4.put( "valid_date_end", "2023-07-26");
        para4.put( "address","广州市天河区五山路433号大院华农嵩山区26102房");
        para4.put("gender", "男");
        para4.put("nation", "汉");
        para4.put("agency", "广州市公安局夭河分局");
        para4.put( "picModel","1");
        para4.put( "liveType","face");
        para4.put("idCardBaseContentAUrl", "http://img.tuanzidai.cn/loan_database/1541984565253.jpeg");
        para4.put( "idCardBaseContentBUrl","http://img.tuanzidai.cn/loan_database/1541501121557.jpeg");
        para4.put("livePhotoContentUrl","http://img.tuanzidai.cn/loan_database/1543170265119.jpeg");
        para4.put("idCardBaseContentA", "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" );
        para4.put("idCardBaseContentB","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");
        para4.put("livePhotoContent","/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAECAQIDASIAAhEBAxEB/8QAGwAAAQUBAQAAAAAAAAAAAAAABAABAgMFBgf/xABDEAABBAECBAQDBAYHBwUAAAABAAIDEQQSIQUxQVETImFxBjKBFEKRoRUjUmKxwSQzU3LR8PEWJTRDc5LhNURUgrL/xAAZAQADAQEBAAAAAAAAAAAAAAAAAQIDBAX/xAAiEQEBAAICAgIDAQEAAAAAAAAAAQIRAyESMUFhBBMiUSP/2gAMAwEAAhEDEQA/AO31Dq38EzgHVv1s2km2v0S+hr4RyJxiY78l1UwF34LjOI8dbm3K95s/ktL4wzzDhx4rXUZj5vYLipHBxDeyeM+Bqels+SHklo2B5qjVuSdlF5TxtDpACaHVaa+D+NCsZgaPFf8AM4eUendQkk1yEk3ZSmlAaednYeiHJs7dU5OtJ+NE55kN/VIBWxQ26yETHAHFG5Jo/Dc0EYwk0AUTFhucaIpaEOI0GmhHQYgG/VZ5csazj37AR4R5kc0bBhaRujY4gT7IhsQ7LG8lbTjmtUJHitsPIV4xQeeyIbHt/JWBqy3F3HcsZ7uHNI2PNIcKa1uo0VqNYFLTSfmV45ZpjnhIc76KP6Fbp00OXZbrGDZWtYD0VfspXCa0wBwIaQGsIHdGs+Gi2ASnmdg3sO63oWi2ivl3+qOb5gLGw6JzJlZ7edcV4HI23tZuRzIXOyxaH1yI/Ne0zYEc0LgQCXBed8e4P9nyXU2gTfJaTTOzrTmYHmN4YdgTv3Xc8BzmysMLn9g0Lh54CyY78qK0+E5jYJWSucdTTyT1E+5p3vIpKLXiSNkjdw4J7R9D30Sa0rSNI+h9HtRSSR9D6JJMkl4z/C0KtN3StNYDXE9Gkn8EKeffFWUcj4gnZdiGmeg2WKXKyeQzZM8pNl8pdffoqH/mQtIkibu1dCdILihxvte5U5HdO+6YJz9by5XRMsaj1Q1g9eq0IWjn+SLdHjNroYx0PMo+CICq3VcENAahSNiFALDLN0YYrYo6FIuNlUqom2AEUwBYWt5EmAVYVjQU7a6BSDgOiWzIBOAUwk9EhL6I2awKSq8QdxaQkJRsaXs2I3VzNghNRVrJa9ktp00IX7Ao6JwB91kQ5ADhaPhlD5LtXjWeUajH1y7UVgfEOF48JfW/RarHU2wUshrZoSDv1Wm2enlGdiuhDnOHK79eyD2jZvYkHMUus4tiNbI91UAaXP50UYLI73cbc5aS7jKzt1Hw/munxBDK7zNAorVXI8GyG4mWzSbDqBtdcavbkU0kmSJSQCSS2TIBJJJIAg8iq8gXh5AHMxO/gpmvzScNUUg7xuFfRI3k7Ga4x2JP8VS9jjIS0E+y2H47GY0Yd5BpJc7shYc7DxmuAuSx1VxNCxR+Gwzyt0tApo7qlxNku5lFZ2SJGRyOHlItrQg22WeI87u5KgnG0FwBWzix69z06LIgFvb1o2uhxI9MTdQpZ8l6bcU7ENbQVzAosbY5K9jaXLa6otjBPLZXsHKyoRg1tur2RnqpUsaWt6qTSHDkoCMqWkhATpqfQ3bZVgOv0UwCgJaGJaG9ktJT6HHogiDApNjab3KkIjuSU7YyDzQNnjhAOzkTE0s6qMcfqimw2NiqkZ2rI5BppXB3kJBVDYXN9goyF2nSPqq9I9sPizWFx3ohc5k4xbJZaDYXQcQbZLyd7WXmdK32V4s8oxoh4EoLtjzXcQTCbFhlHN7RsuJymBg8W+lBdhwsf7pxjsTo6LRnRKSSSZEkkkgEkkkgLuqkw0/fko90rSNw3xBB9nZLG4bMkcPpS5WRvnLK2rZekfE2D9pxHyAcx5vReeZLZIXkEAEJyjSc+kY2BDI7Q5sbi72vb8lGR7ZXtETaY3Zt9VTkNJyNbjq1NBs9PRXQtAcAd/5K9loVjQeYDqTzXQwN1RihsNln4cV0QOYW3BDoiFj1XPnXThNFHHTVc2O1FzmxjzGieQVRz2R8+yzmO2ty00GM7igrWjcArAl49RIaR+Cpbxuc24MsdN0/BPm6oN7WnCwMbjL3VfXstGDPEvUKbjpcux53T0qhKCAVISKTT5BJ0rY2aiVTJNXsgMnJJb9U4KPkz44t3OQ54uwyaW77WT2WHlvkk3a4X7IdrJG3VknmVpMYztdIPiGFr9N7g7+i1cPjMErR5guC8DQ0g8zzKtx53sf5XbBPxTuvUWZMMrPK4En1VT2gkkbrjMTicrdLrXU8Lz4sllE+Yi9kqSnLwmPLndey5vOi8PlZoLs5YwfKFh8WxgGkgXd70iXVK9xyk4a+AN01R3K6Xg8bP0RAS5wJFWFgOYKIutPNdHwxoZwrHa3lVrZhaKDf3rSr1CZJMj0mPuntNqQDJJWkgLx190khySSNCSNssTo38nBcTx3gbxI5gFa92Ormu5Q2XjtyYi1wBddg9khHlbopI5PClFObWx5ohkQD/dddxjhMeZw2WZsYGRjt1bcyuYhaXPjFbuIb9f8AVPZ/LpOFYWtgkIptbLQka1m/QDkiYMf7PDHF2ATSRjw3GrPRc99uqemDlvcXFxrW47DsFmSMe6+v81uy4vmNi6UfAYOgKqZaK42sKPGe53IgFENw+t0tGQMa26CGfIGm6Rc6qYQ0cDW6fQ2i4G6HIdkwI2CtbIdQAUXJpMY0mS7UrfE32QUch22Voco2el7zY2QsrAW7hXB2yrkcEbGg/h0oO0tvYKUklISQkguc4NYOZJTnabIfw2voEkd1dFiRAbAWVmu4xw6A6XZF+yuh45iSbtd12V/1CnjemrFjC+QoLW4a0QytKyMbLilbbHghaUEoBHfsl5FcXSa2uoofNx9cD6FkAqnHmLowbR0cge7SRzCcrOx57leVkp6736FdRBGIsSFg3AY3+CwuJY4ZnuxQL1ZAoen+i6B/zkDkNguiOalaSak1pke0ySSASSSSAJpMnTJAyYhSTIOKfCaZT+y8UQuFixHQ/EDcVwrTkgV6Xsu/9FhZuGD8ZcJkAoZEjb+h/wAElT23MiOpHemyGf5WmjaOy6Eh7WsnLkoaWnmaXNa6sZsNM5oJIPNZ+TlNibqd9B3SzcoMJrkOiwMv7RlSFsdkk/gidtL0Im4vu/Q3VpG/YdEEeOSO545oeq2/0REzgU0MY/WvaLcefO1z7gGDwgzejey3kjnyzy20sPOiyt2bFaTNqWFwzEMOPNPuNT/KPQdV0UENwQvI3cwEj1pY54xthdztZFaKZGXUqoo7paWPCKulDTYXw3C+yolBorXkhAZy3QMsBqgkNswsc80Bv/krJ4jBLxHAmkhdUDLDKPzUea6F8NRSNB8z2loPbakGyFuPCIG7ta2qV43SMptyIx4mNbG1oLqs3RW1wjg8LuF5OXk+UWRGORNBHM4Rjai7wxZ9VpR47SGB2zG7BvRa3OMphXMYkWZj7ltNXQYOS6QDVstD7JHI3TpURw8R+ZoWOX01l/0ZjZBBa1bmOWubrG+ywcdhBsha+O8NiO+98kY1OXbL4ligfFEMjvl8LxB6lXF7Q8g2XHoGn/IRmfHHLnYz3v0gxlpd2RTOLYXDovDxY2tAHnfW5PquiZyTtzTjyyvTIDxdbg9i0gp0dPxfE41jSaGgyw/eQKrHKWbic+PLC+ORJJrTqkEkmSQBdJiFaWKJb3QEKUT2Ask0FZpTw03Iic4bNeCUjEN4fjsZc8xMnUDkFlzQNPxDwVwN6Znf/krKyeI5mHxfKZM9zmmQkDsP9Edw7MOVxrhbiP8Amkj6tP8ANc85N3Ttz/H8MZk0M3cFo7rGygS9xrpQWvlmpdH+eaDkh18huVNGPUYR4eZ3lx2CJZw+OFtafyWs3FEcYHXqqXsIJR6O3bNdHVtaSQRW6Bfgwl5f4Y1HqtpzAOipkjBtPyHizmQNaaq66UtBkR0ixz/JTgg8xeR7IjSlbtUipke42R8DaaAqWx9UXG2gO6QtM8WChnx2UW4GlSd0ilCOhBu0HNikO2C03Ck2nUPVCmdHEAbNfgiWRqT4K5FSZGQd0BdEzakQwAEAi91THsVaZWx1YJQixecdhaS3mkyGntPraeKS975jkrVURQfFnaYIH/vke6x8qxjiU7Mvf95H/EM/hswohvqc9x+io+zHPjgjGzNyVOfd1HVwaw1lUOBRGPEyJ+QmdQRyl5GNbHEKjZs31UV08WHjjpw/kcv7eS5EkkktHOSSVpIDrjwjHIIa57T3u1lZmGcaQtvWKsEdV0lIGeJs2a1pGwopkyTw/KaAXY7hfY2h5YHxWHtc087IK6yghs8tbhSlwvy0gOE+I8IPMOfFvbdEg7FD4Rbjz8HyCaHiC/bUR/Bbzg0tdFKLjkGl19FznHYH4kEMUYP6geU//a7XLnj43cejx8nnh4VvZTQMx7T90fzSaxt2VLJlZK6Odu4mYHfjuoahsprOJPA6IeRoq075gLVDpSSQkuRU9ovmoCIHn1V+jUbJT0ByCFoUAFHa9k8jqBVDX27nz6pAYzdoRTBshoRYACNDQ0BOIpi21Q+KhfZFWO6uY1jozdWU9F6Y8rqvooRyd1bxCMx2WhARyhym9NJ2PbTlLQO6qjfyVodYRBTBtGwlzUrACimS6J9IjUSLQjHDdOx7i4N+73TRWb8RPEnEceH+ziBNdCf/AAtGNghwIWged7TZ7BQysHHHE/tDy+SacCm/dZSsncC8NHJjQP8AFVxz+tjm5P8AnMUOlJJk9rpcBJWmSQCSSSQHfoeIa8iR/bYK4mgSegVeO2ogTzJtMLlm8XkqFjAd3G1pLC4rLryXNB2aKQGXJvao4pjtzMOE7B1Fjvor3FRLGzROx3O0iQWHdis8puNePLxz2AwC88Njil+fHtnuOis10OarwWSwmaDIFOG34J3DSSPQrCx09WmO6m1oVYPdSsg81K4soKDhsfZSVL386KDgeeTYhU4A+0zyEHyRbE+pUcx+mMjnsr+FluNwphd80rnSH8VPyvXQ+J7YxZPVO7LBqysTM4pHCac8Dfkh2cTZJu14P1T2XjHQ/ah3UmZukg3t2XPDMceR5qjI45j4rwHyCz0RLaLjHaMdFlMOqjfRc3mxHh/EnQjdrvlUeGcdjn3jdyVvFJhkz47vvUbTt31Sk8buCI32Fe11ISLYUVe0lJVWFxJq1IG9rVVqcPmcU0Va0UaVsY3BrcJgwWDauYH84xqcDyTntllU8iCPGjGTJbpj5W97QPur8zIOTMN/LGKaO56lULoxmnLnd0kk6StBkgnpJAMknpJAd3J8hHfZOBQoJnUXhv1UkwjI8Mjc8nYC1zWQ8ue4nclbfE5fDxS293mlz0jkgrdzUDvXopEqBSNdoZlNa4mpWbH1QuTF4byOanq8O3jmPzU3N8THe8ut4Kzyxa4ZfDOvd3oVEPNn0VjgAdiouFc1jXTKTnk9d1U486Sc7zKDnc1NaxTLGZAgcjIOPE1hsACgteFmsFypzMNkzKcCke9VxXEMeTOyS8ylovb2TxwPgALSXd1uHhYsGzt6KyPAa3or6FsZmqYx0LBIpCu4dGRqmtz7vddGMRoPJO7Da6uVJFth4rRjvPhXuugwIpJD40o35AJosOFhDtItGx0AANtkhtIMAU2mlEkdSo66UhbqCvx9I5DmEIHC0TBsTvsqiaK1UPS0fgwl+LmvAPli2PrzKzrBFE9VqY2QcXg0sgcP10xYPbkVpxztz8t/lisNsB7hSTNbpYB2Ul0uUydJJAKkgElIIBUEk6SA7GCUTTSOB2bsiVzmLxGbFBYwMka510diiXccdpcBj06tjrsfyTCHFsjXkaAdmCllPdalJI5zi5xsk2VUUjIlNaZMXBoJd0CQRd5nhvRm59+itgcCTGeT1SLaPN8xNlODRBHMJCBpdpy2qF7qqR2qkRmijrA2cgHSaR9NlhlNV2YXcM6QWfdVPkA2Cqe6t+qoMtOHobWTeNeOVjGEWn8UOH8VjtyaI3RcU4Lavmmna5zfMeyk2G1IzwRM1SPA23Cy8j4ijZIRE22jqg5LR5afFLa5FXOgrosv9P4/heJR1dqQLuOZL5C4VV7C0+1eDffE4DZUvcWuG/RZzPiKMNAlFJScYxZKLZRfaku02UcZxG49UvtAdyWUc1srSWuBBVuLJrvfb1Som2i2WzaOxnHRfMkLNjHJFtDjGWtNE9UQUaXWWgcy6loZz6xsKAfKxjnn1JKz4gPEFc28kZm/18bP7OFoW/H7cnNelCekqSW7nKkqTpkAqThIBOAgEkn0pIArUoOd6pWq3OslASJUbUbStIHTUD0StRtBnITJEprSCM/mgon5Vjy7Guy2gQXaTuHbLGymOa4sOxaatZZx0cdDONoaUVZVheBtai9wLVhXVGY57oySLKrl4tLELa0FGSRiQ+iiMWNrrLQfoiU9RkuzsrKJLia7UmLpRQLByWs7DDfMzYeqQhG11+C0mmuMjKjMh+4io8PJlGprA1vqji1pNADf0V4m+640Ve4pmu4Y0NHiS24dAmZwszyU0lrB95aQga51udsSjAGMbpaAouUZ5VkswHRimbgBWRSCENa47udSPICodGzWDQJBsLG1OxsThpF80S2RZ7XFooC+3qjIgbA50LcVURk1MHz5DR0A1FF5m+Sf7oQ/DW0HOPM0D/JW5O+VJ+C6ONycyATpgpLZgSalJIboIgFMM7pgFYAgzaQkpJICBNBV/wAVJyigG2SSTIB0xTqJKARKiSmJUbSNO0JxOIOaJm9RRRBKcM8eKSL71WFGU6aY3tzUvzbbFUPcfoictjmTuFUhjThS5q7JUBIArC8Hqh5GaeqbdS02udIQKVL5dtzRU6LgqvAc/wC6iHFXiuDrBCdkhL9VlEMwi7bTv3VwwCzkE1bPC+2j2RLDpFc1WzHcDVVsrhEW8ypRsznbKkAl1lE6ARSTIfwQW0omAMLjzHJGQs0saOpNlVxMBc1o+VvNEAanUeqpDQwRsANtbk8jtU0h/eT4Ish5Owsj6Ksbk+pXRxOXm9pgJwmCmAFs5zUpAJJwgJAKQUQVNo7lBlskpUEkBQ8blQKlyaATZrdRKYRtJOQmQCJUSU5USkESoEqTiqZZo4W65XhjR1ckay1KBwbkMJ5E6VSyRkjA+Nwe2+YSc7SL6g2lTini+JuZGi6HmHqsB7aJ3srss2IPe8A0Ty9VzObjmN5Naa5grkruxBEWmESkUmyAGj2UbWmyMdUVCI6II5IQy6d+iYZYLtjyTlNqeUDalElo9UA3NBG5G6X2i+vNGz00C9oG3VVageqE+0tDgT0Ci2a+qNjTQY0bbp3P000buPTsghkEAAfN2V7DpsvNuKNpoyMiNmntz9VbATIdztzJHRBeLqdVj1J6LRwMd2RV+SAHn1eewThXpqYgHgPcBtpIb7UhmfI32WjCAS9gFfq3Ch02WbEbjb7Lp4vTj5fa4J7UQVILVgknCYJwgJilIAKLQSaAJPQIfL4jiYG0r9cp5RM3cfr0QBleiSwv9pJ//gM/70kG1z3UCFPrSYpkrI5eqfY8inre1TkYjMg2ZXxn91ASIPUH6KJUIsV0Jv7Q547FpVlJGqcoG6IaatWPCrP8Egj5WigAB2ApDZmZDisqUu1Obelo3A9VPIyGwx+KRbRsxv7RWJP4k7JXvOqSRJUdrMxszGA7XG0g9rAKyM/Ge0VI3U0cnDkVtzt0Oaz9hjW/g2kHPK1upnPbcdFx5e3bi5PJgey3NFt6+iCMjXdd/VdJkwtaC5rSAVk5fD2TW5h0lRttGe9xCqeSQa6pSty8V1Pj1stQblROvUCxyN7Vo4PL0Uw923ootdEflkBVo0dHBMzWSVbExztlEOYOVlTAlfswUOpKCohro4RZIs9SmjlkyX6MZhd3ceQUGQY7adPJqPZHYz5pBpxYCxv7RGyRaG4mDHBUmQ8Od26LUhn8YhsABoVq5ALPg4fZDsmYv/dateHQyMNY0NA6BVGeQ3DAbM1oNjez3tZLPKCy92uI/NauOaka7sUFlReDnzsqgXax6grp464+WItHVTCiE7nNjYXveI2j7zlrtjpIV0UMnJgwovEyZRGOjfvO+iyszj5aTHgs67zvG30b1QDMWbJk8XIkOo/efuf/AAjYE5fHMjJuLGaceM993uQ8OE/cyu0XzHzPd7lFQwxQkNha4yH0txR8HCpJADkP8JpPyt5/U9EdhnfZMfsP+5Jb36K4f/YN/EpI7DF4b8U42ZI2HMb9mmPI/dd/gtxwI5gkdCOq8snBhkLDyJtaOBx7OEbcMcSmgaDTCHcj2KoO/sdCkT6hcM34n47hZxgycsy6NzHPE3S4dDYF0tZ3xa9wDBiwY8lf815IPsUE6E16JadrN0Oq4/L+MM3HY5rZsWSY7NZGwOr3olAwZmdxVj38QzHvefMIWupoCDd29nSxfQXuh5WOHlPlaN3ElcdD4GO/VCxrC5ukkdCFdJmOc2nSu09fMSloDuNcVxcDDkzpWnIMbhG1jdgCdlf8DTZHxCZOKZOBDj8PgcRC63appOwvah/Fc/NNj5UEuJksLoZKDgTuKN2vQeE5WJLwuCDBLBDEzQ2Nu1D2WfJbJ0145LexEkmtxdfW0Hktp7TXTcqyXWyQ7E/Sk5LXMpwsHqFyV1QK1muNwIsLOyYGg8yFtMa1jKB1WUJkxam3RuuilcYUsbwTuHUgZ4Y5BckNHrS15IxZ3pDvh1XRSkabYrsHHJFFwTDhzf7fb2K034rujQfooGAt5h1J7G1MWAxtfrj6otmNCzYyPcotjA3V8cTbtwcgbXQjGjNtiB/vIxkr3CgKHYIaOMEihyRcMZ2/NGiEw3129kXGQK2VUEdNskK4Cul+yuM6Lh3Fd0XlcNkzxBLA0F7RofZ2pDQ/d33/AILVw5TEQbFEUQStcLqsOSbjMk4JmxVUYkB6sd/jSAy+Bfaml00WQQ3tdD6Uurgz45sl+LIBHM3cMJvW3o4IbifH8DhjCJZQ6TpG3c36rp1K5rbOnHN4PFG/VBIdXeTc/RSZw17j+smaWdSwbn8VVxL4izOJ5TXsjDS3Zraugpw5PEK/pT4mAchsXH3QTRxo4sdpELA397r+KvG4o8kFj5ORLWmJrm9XuFNH1RjCaGoC/wB20wlYSTa4+ySA8p4hzZ9UA/n9UkkBqcb/AOH4e7qY3C1KLfhLfQhJJBDcDHgEbnCGMO089ItBf+9Z/wBRJJBrpf6ib/qMUJB5ikkmA0vN39xD4080eaDHK9m/3XEJJLPL0vH29N4Q98sLfEc5/wDeNoqTZ7kklxV2RS/mVU/5D7JJKVxn5HMoOTqkknDIp/upJKVHoahskEkkwvj5q+HqkkmGhjfIEQ/ZqSSqM6Lh/q2oyHeVvukkrntlfTH+LDXFeFOGzrcLHNYXHf8A1Nx/dSSXTi5cva7h4rC1DY3zCkzfJaDv7pJKktl2zWVshsxzhA+nEexSSTDzx2Xk6j/SZef7ZSSSQH//2Q==");
        Map<String,Object> para6 = new HashMap<String, Object>();
        para6.put( "confidence","82.584");
        para5.put("1e-3","62.169");
        para5.put("1e-5","74.399");
        para5.put("1e-4","69.315");
        para5.put("1e-6","78.038");
        para6.put("thresholds",para5);
        para4.put("result_idcard_photo",para6);
        para3.put("ocr",para4);
        paras.put("authInfo",para3);
        paras.put("channelUserId",channelUserId);
        Map<String,String> para7= new HashMap<String,String>();
        para7.put("name", "OCR");
        para7.put( "organization","1");
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0,para7);
        paras.put("creditList",listPara1);
        return null;
    }

    @Override
    public  Map<String, Object> defautApply(OneClickModel oneClickModel,String name,String channelUserId) {
        return null;
    }




    public static void main(String[] arg){
//        OneClickModel oneClickModel2 = new OneClickModel();
//        oneClickModel2.setType("1");
//        oneClickModel2.setChannel("159858");
//        oneClickModel2.setTermNo("12");
//        oneClickModel2.setPhone("17800000009");
//        oneClickModel2.setAmount("10000");
//        oneClickModel2.setFundID("710");
//       ApplyLoanServiceImpl  applyLoanService=new ApplyLoanServiceImpl();
//        applyLoanService.applyLoan(oneClickModel2);
        System.out.print("打印时间"+System.currentTimeMillis());

    }

}
